/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientMultipartForm;
import io.vertx.core.http.impl.ClientMultipartFormDataPart;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClientMultipartFormImpl
implements ClientMultipartForm,
Iterable<ClientMultipartFormDataPart> {
    private Charset charset = StandardCharsets.UTF_8;
    private final List<ClientMultipartFormDataPart> parts = new ArrayList<ClientMultipartFormDataPart>();
    private final boolean multipart;
    private boolean mixed;

    public ClientMultipartFormImpl(boolean multipart) {
        this.multipart = multipart;
        this.mixed = true;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    @Override
    public Iterator<ClientMultipartFormDataPart> iterator() {
        return this.parts.iterator();
    }

    @Override
    public ClientMultipartForm attribute(String name, String value) {
        this.parts.add(new ClientMultipartFormDataPart(name, value));
        return this;
    }

    @Override
    public ClientMultipartFormImpl charset(String charset) {
        return this.charset(charset != null ? Charset.forName(charset) : null);
    }

    @Override
    public ClientMultipartFormImpl charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public ClientMultipartForm mixed(boolean allow) {
        this.mixed = allow;
        return this;
    }

    @Override
    public boolean mixed() {
        return this.mixed;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public ClientMultipartForm textFileUpload(String name, String filename, String mediaType, Buffer content) {
        this.parts.add(new ClientMultipartFormDataPart(name, filename, content, mediaType, true));
        return this;
    }

    @Override
    public ClientMultipartForm binaryFileUpload(String name, String filename, String mediaType, Buffer content) {
        this.parts.add(new ClientMultipartFormDataPart(name, filename, content, mediaType, false));
        return this;
    }

    @Override
    public ClientMultipartForm textFileUpload(String name, String filename, String mediaType, String pathname) {
        this.parts.add(new ClientMultipartFormDataPart(name, filename, pathname, mediaType, true));
        return this;
    }

    @Override
    public ClientMultipartForm binaryFileUpload(String name, String filename, String mediaType, String pathname) {
        this.parts.add(new ClientMultipartFormDataPart(name, filename, pathname, mediaType, false));
        return this;
    }
}

