/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonObject;

public class JsonConfigStore
implements ConfigStore {
    private final VertxInternal vertx;
    private final JsonObject config;

    public JsonConfigStore(Vertx vertx, JsonObject configuration) {
        this.vertx = (VertxInternal)vertx;
        this.config = configuration;
    }

    @Override
    public Future<Buffer> get() {
        PromiseInternal promise = this.vertx.promise();
        if (this.config == null) {
            promise.fail("no configuration");
        } else {
            promise.complete((Object)this.config.toBuffer());
        }
        return promise.future();
    }

    @Override
    public Future<Void> close() {
        return this.vertx.getOrCreateContext().succeededFuture();
    }
}

