/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.SecurityActions;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.DispatchUtils;
import io.undertow.util.BadRequestException;
import io.undertow.util.ParameterLimitException;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Deque;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestDispatcherImpl
implements RequestDispatcher {
    private final String path;
    private final ServletContextImpl servletContext;
    private final ServletChain chain;
    private final boolean named;

    public RequestDispatcherImpl(String path, ServletContextImpl servletContext) {
        this.path = path;
        this.servletContext = servletContext;
        this.named = false;
        this.chain = null;
    }

    public RequestDispatcherImpl(ServletChain chain, ServletContextImpl servletContext) {
        this.chain = chain;
        this.named = true;
        this.servletContext = servletContext;
        this.path = null;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(() -> {
                    this.forwardImplSetup(request, response);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof ServletException) {
                    throw (ServletException)e.getCause();
                }
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        } else {
            this.forwardImplSetup(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardImplSetup(final ServletRequest request, final ServletResponse response) throws ServletException, IOException {
        final ServletRequestContext servletRequestContext = SecurityActions.currentServletRequestContext();
        if (servletRequestContext == null) {
            UndertowLogger.REQUEST_LOGGER.debugf("No servlet request context for %s, dispatching mock request", (Object)request);
            this.mock(request, response);
            return;
        }
        ServletContextImpl oldServletContext = null;
        HttpSessionImpl oldSession = null;
        if (servletRequestContext.getCurrentServletContext() != this.servletContext) {
            try {
                oldServletContext = servletRequestContext.getCurrentServletContext();
                oldSession = servletRequestContext.getSession();
                servletRequestContext.setSession(null);
                servletRequestContext.setCurrentServletContext(this.servletContext);
                this.servletContext.invokeAction(servletRequestContext.getExchange(), new ThreadSetupHandler.Action<Void, Object>(){

                    @Override
                    public Void call(HttpServerExchange exchange, Object context) throws Exception {
                        RequestDispatcherImpl.this.forwardImpl(request, response, servletRequestContext);
                        return null;
                    }
                });
                servletRequestContext.setSession(oldSession);
                servletRequestContext.setCurrentServletContext(oldServletContext);
                servletRequestContext.getCurrentServletContext().updateSessionAccessTime(servletRequestContext.getExchange());
            }
            catch (Throwable throwable) {
                servletRequestContext.setSession(oldSession);
                servletRequestContext.setCurrentServletContext(oldServletContext);
                servletRequestContext.getCurrentServletContext().updateSessionAccessTime(servletRequestContext.getExchange());
                throw throwable;
            }
        } else {
            this.forwardImpl(request, response, servletRequestContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardImpl(ServletRequest request, ServletResponse response, ServletRequestContext servletRequestContext) throws ServletException, IOException {
        HttpServletRequestImpl requestImpl = servletRequestContext.getOriginalRequest();
        HttpServletResponseImpl responseImpl = servletRequestContext.getOriginalResponse();
        if (!this.servletContext.getDeployment().getDeploymentInfo().isAllowNonStandardWrappers()) {
            if (servletRequestContext.getOriginalRequest() != request && !(request instanceof ServletRequestWrapper)) {
                throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
            }
            if (servletRequestContext.getOriginalResponse() != response && !(response instanceof ServletResponseWrapper)) {
                throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(response);
            }
        }
        response.resetBuffer();
        ServletRequest oldRequest = servletRequestContext.getServletRequest();
        ServletResponse oldResponse = servletRequestContext.getServletResponse();
        request.removeAttribute("javax.servlet.include.request_uri");
        request.removeAttribute("javax.servlet.include.context_path");
        request.removeAttribute("javax.servlet.include.servlet_path");
        request.removeAttribute("javax.servlet.include.path_info");
        request.removeAttribute("javax.servlet.include.query_string");
        String oldURI = requestImpl.getExchange().getRequestURI();
        String oldRequestPath = requestImpl.getExchange().getRequestPath();
        String oldPath = requestImpl.getExchange().getRelativePath();
        ServletPathMatch oldServletPathMatch = ((ServletRequestContext)requestImpl.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getServletPathMatch();
        ServletPathMatch pathMatch = null;
        if (!this.named) {
            try {
                pathMatch = DispatchUtils.dispatchForward(this.path, requestImpl, responseImpl, this.servletContext);
            }
            catch (BadRequestException | ParameterLimitException e) {
                throw new ServletException(e);
            }
        }
        try {
            try {
                servletRequestContext.setServletRequest(request);
                servletRequestContext.setServletResponse(response);
                if (this.named) {
                    this.servletContext.getDeployment().getServletDispatcher().dispatchToServlet(requestImpl.getExchange(), this.chain, DispatcherType.FORWARD);
                } else {
                    this.servletContext.getDeployment().getServletDispatcher().dispatchToPath(requestImpl.getExchange(), pathMatch, DispatcherType.FORWARD);
                }
                if (!request.isAsyncStarted()) {
                    if (response instanceof HttpServletResponseImpl) {
                        responseImpl.closeStreamAndWriter();
                    } else {
                        try {
                            PrintWriter writer = response.getWriter();
                            writer.flush();
                            writer.close();
                        }
                        catch (IllegalStateException e) {
                            ServletOutputStream outputStream = response.getOutputStream();
                            outputStream.flush();
                            outputStream.close();
                        }
                    }
                }
            }
            catch (IOException | ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            servletRequestContext.setServletRequest(oldRequest);
            servletRequestContext.setServletResponse(oldResponse);
            boolean preservePath = servletRequestContext.getDeployment().getDeploymentInfo().isPreservePathOnForward();
            if (preservePath) {
                requestImpl.getExchange().setRelativePath(oldPath);
                ((ServletRequestContext)requestImpl.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY)).setServletPathMatch(oldServletPathMatch);
                requestImpl.getExchange().setRequestPath(oldRequestPath);
                requestImpl.getExchange().setRequestURI(oldURI);
            }
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(() -> {
                    this.setupIncludeImpl(request, response);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof ServletException) {
                    throw (ServletException)e.getCause();
                }
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        } else {
            this.setupIncludeImpl(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupIncludeImpl(final ServletRequest request, final ServletResponse response) throws ServletException, IOException {
        final ServletRequestContext servletRequestContext = SecurityActions.currentServletRequestContext();
        if (servletRequestContext == null) {
            UndertowLogger.REQUEST_LOGGER.debugf("No servlet request context for %s, dispatching mock request", (Object)request);
            this.mock(request, response);
            return;
        }
        final HttpServletRequestImpl requestImpl = servletRequestContext.getOriginalRequest();
        final HttpServletResponseImpl responseImpl = servletRequestContext.getOriginalResponse();
        ServletContextImpl oldServletContext = null;
        HttpSessionImpl oldSession = null;
        if (servletRequestContext.getCurrentServletContext() != this.servletContext) {
            oldServletContext = servletRequestContext.getCurrentServletContext();
            oldSession = servletRequestContext.getSession();
            servletRequestContext.setSession(null);
            servletRequestContext.setCurrentServletContext(this.servletContext);
            try {
                servletRequestContext.getCurrentServletContext().invokeAction(servletRequestContext.getExchange(), new ThreadSetupHandler.Action<Void, Object>(){

                    @Override
                    public Void call(HttpServerExchange exchange, Object context) throws Exception {
                        RequestDispatcherImpl.this.includeImpl(request, response, servletRequestContext, requestImpl, responseImpl);
                        return null;
                    }
                });
            }
            finally {
                servletRequestContext.getCurrentServletContext().updateSessionAccessTime(servletRequestContext.getExchange());
                servletRequestContext.setSession(oldSession);
                servletRequestContext.setCurrentServletContext(oldServletContext);
            }
        } else {
            this.includeImpl(request, response, servletRequestContext, requestImpl, responseImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeImpl(ServletRequest request, ServletResponse response, ServletRequestContext servletRequestContext, HttpServletRequestImpl requestImpl, HttpServletResponseImpl responseImpl) throws ServletException, IOException {
        if (!this.servletContext.getDeployment().getDeploymentInfo().isAllowNonStandardWrappers()) {
            if (servletRequestContext.getOriginalRequest() != request && !(request instanceof ServletRequestWrapper)) {
                throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
            }
            if (servletRequestContext.getOriginalResponse() != response && !(response instanceof ServletResponseWrapper)) {
                throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(response);
            }
        }
        ServletRequest oldRequest = servletRequestContext.getServletRequest();
        ServletResponse oldResponse = servletRequestContext.getServletResponse();
        Object requestUri = null;
        Object contextPath = null;
        Object servletPath = null;
        Object pathInfo = null;
        Object queryString = null;
        Map<String, Deque<String>> queryParameters = requestImpl.getQueryParameters();
        ServletPathMatch pathMatch = null;
        if (!this.named) {
            requestUri = request.getAttribute("javax.servlet.include.request_uri");
            contextPath = request.getAttribute("javax.servlet.include.context_path");
            servletPath = request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = request.getAttribute("javax.servlet.include.path_info");
            queryString = request.getAttribute("javax.servlet.include.query_string");
            try {
                pathMatch = DispatchUtils.dispatchInclude(this.path, requestImpl, responseImpl, this.servletContext);
            }
            catch (BadRequestException | ParameterLimitException e) {
                throw new ServletException(e);
            }
        }
        boolean inInclude = responseImpl.isInsideInclude();
        responseImpl.setInsideInclude(true);
        DispatcherType oldDispatcherType = servletRequestContext.getDispatcherType();
        ServletContextImpl oldContext = requestImpl.getServletContext();
        try {
            requestImpl.setServletContext(this.servletContext);
            responseImpl.setServletContext(this.servletContext);
            try {
                servletRequestContext.setServletRequest(request);
                servletRequestContext.setServletResponse(response);
                this.servletContext.getDeployment().getServletDispatcher().dispatchToServlet(requestImpl.getExchange(), this.named ? this.chain : pathMatch.getServletChain(), DispatcherType.INCLUDE);
            }
            catch (IOException | ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            responseImpl.setInsideInclude(inInclude);
            requestImpl.setServletContext(oldContext);
            responseImpl.setServletContext(oldContext);
            servletRequestContext.setServletRequest(oldRequest);
            servletRequestContext.setServletResponse(oldResponse);
            servletRequestContext.setDispatcherType(oldDispatcherType);
            if (!this.named) {
                requestImpl.setAttribute("javax.servlet.include.request_uri", requestUri);
                requestImpl.setAttribute("javax.servlet.include.context_path", contextPath);
                requestImpl.setAttribute("javax.servlet.include.servlet_path", servletPath);
                requestImpl.setAttribute("javax.servlet.include.path_info", pathInfo);
                requestImpl.setAttribute("javax.servlet.include.query_string", queryString);
                requestImpl.setQueryParameters(queryParameters);
            }
        }
    }

    public void error(ServletRequestContext servletRequestContext, ServletRequest request, ServletResponse response, String servletName, String message) throws ServletException, IOException {
        this.error(servletRequestContext, request, response, servletName, null, message);
    }

    public void error(ServletRequestContext servletRequestContext, ServletRequest request, ServletResponse response, String servletName) throws ServletException, IOException {
        this.error(servletRequestContext, request, response, servletName, null, null);
    }

    public void error(ServletRequestContext servletRequestContext, ServletRequest request, ServletResponse response, String servletName, Throwable exception) throws ServletException, IOException {
        this.error(servletRequestContext, request, response, servletName, exception, exception.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(ServletRequestContext servletRequestContext, ServletRequest request, ServletResponse response, String servletName, Throwable exception, String message) throws ServletException, IOException {
        ServletPathMatch pathMatch;
        if (request.getDispatcherType() == DispatcherType.ERROR) {
            UndertowServletLogger.REQUEST_LOGGER.errorGeneratingErrorPage(servletRequestContext.getExchange().getRequestPath(), request.getAttribute("javax.servlet.error.exception"), servletRequestContext.getExchange().getStatusCode(), exception);
            servletRequestContext.getExchange().endExchange();
            return;
        }
        HttpServletRequestImpl requestImpl = servletRequestContext.getOriginalRequest();
        HttpServletResponseImpl responseImpl = servletRequestContext.getOriginalResponse();
        if (!this.servletContext.getDeployment().getDeploymentInfo().isAllowNonStandardWrappers()) {
            if (servletRequestContext.getOriginalRequest() != request && !(request instanceof ServletRequestWrapper)) {
                throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
            }
            if (servletRequestContext.getOriginalResponse() != response && !(response instanceof ServletResponseWrapper)) {
                throw UndertowServletMessages.MESSAGES.responseWasNotOriginalOrWrapper(response);
            }
        }
        ServletRequest oldRequest = servletRequestContext.getServletRequest();
        ServletResponse oldResponse = servletRequestContext.getServletResponse();
        try {
            pathMatch = DispatchUtils.dispatchError(this.path, servletName, exception, message, requestImpl, responseImpl, this.servletContext);
        }
        catch (BadRequestException | ParameterLimitException e) {
            throw new ServletException(e);
        }
        try {
            try {
                servletRequestContext.setServletRequest(request);
                servletRequestContext.setServletResponse(response);
                this.servletContext.getDeployment().getServletDispatcher().dispatchToPath(requestImpl.getExchange(), pathMatch, DispatcherType.ERROR);
            }
            catch (IOException | ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            AsyncContextImpl ac = servletRequestContext.getOriginalRequest().getAsyncContextInternal();
            if (ac != null) {
                ac.complete();
            }
            servletRequestContext.setServletRequest(oldRequest);
            servletRequestContext.setServletResponse(oldResponse);
        }
    }

    public void mock(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw UndertowServletMessages.MESSAGES.invalidRequestResponseType(request, response);
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        this.servletContext.getDeployment().getServletDispatcher().dispatchMockRequest(req, resp);
    }
}

