/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.ClientTypeSignature;
import io.trino.jdbc.$internal.client.ClientTypeSignatureParameter;
import io.trino.jdbc.$internal.client.Column;
import io.trino.jdbc.$internal.client.NamedClientTypeSignature;
import io.trino.jdbc.$internal.client.Row;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.$internal.guava.collect.Maps;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class FixJsonDataUtils {
    private FixJsonDataUtils() {
    }

    public static Iterable<List<Object>> fixData(List<Column> columns, List<List<Object>> data) {
        if (data == null) {
            return null;
        }
        Objects.requireNonNull(columns, "columns is null");
        ClientTypeSignature[] signatures = (ClientTypeSignature[])columns.stream().map(Column::getTypeSignature).toArray(ClientTypeSignature[]::new);
        ImmutableList.Builder rows = ImmutableList.builderWithExpectedSize(data.size());
        for (List<Object> row : data) {
            Preconditions.checkArgument(row.size() == signatures.length, "row/column size mismatch");
            ArrayList<Object> newRow = new ArrayList<Object>(row.size());
            for (int i = 0; i < row.size(); ++i) {
                newRow.add(FixJsonDataUtils.fixValue(signatures[i], row.get(i)));
            }
            rows.add(Collections.unmodifiableList(newRow));
        }
        return rows.build();
    }

    private static Object fixValue(ClientTypeSignature signature, Object value) {
        if (value == null) {
            return null;
        }
        if (signature.getRawType().equals("array")) {
            List listValue = (List)value;
            ArrayList<Object> fixedValue = new ArrayList<Object>(listValue.size());
            for (Object object : listValue) {
                fixedValue.add(FixJsonDataUtils.fixValue(signature.getArgumentsAsTypeSignatures().get(0), object));
            }
            return fixedValue;
        }
        if (signature.getRawType().equals("map")) {
            ClientTypeSignature keySignature = signature.getArgumentsAsTypeSignatures().get(0);
            ClientTypeSignature valueSignature = signature.getArgumentsAsTypeSignatures().get(1);
            Map mapValue = (Map)value;
            HashMap<Object, Object> fixedValue = Maps.newHashMapWithExpectedSize(mapValue.size());
            for (Map.Entry entry : mapValue.entrySet()) {
                fixedValue.put(FixJsonDataUtils.fixValue(keySignature, entry.getKey()), FixJsonDataUtils.fixValue(valueSignature, entry.getValue()));
            }
            return fixedValue;
        }
        if (signature.getRawType().equals("row")) {
            List listValue = (List)value;
            Preconditions.checkArgument(listValue.size() == signature.getArguments().size(), "Mismatched data values and row type");
            Row.Builder row = Row.builderWithExpectedSize(listValue.size());
            for (int i = 0; i < listValue.size(); ++i) {
                ClientTypeSignatureParameter parameter = signature.getArguments().get(i);
                Preconditions.checkArgument(parameter.getKind() == ClientTypeSignatureParameter.ParameterKind.NAMED_TYPE, "Unexpected parameter [%s] for row type", (Object)parameter);
                NamedClientTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                Object fixedValue = FixJsonDataUtils.fixValue(namedTypeSignature.getTypeSignature(), listValue.get(i));
                if (namedTypeSignature.getName().isPresent()) {
                    row.addField(namedTypeSignature.getName().get(), fixedValue);
                    continue;
                }
                row.addUnnamedField(fixedValue);
            }
            return row.build();
        }
        switch (signature.getRawType()) {
            case "bigint": {
                if (value instanceof String) {
                    return Long.parseLong((String)value);
                }
                return ((Number)value).longValue();
            }
            case "integer": {
                if (value instanceof String) {
                    return Integer.parseInt((String)value);
                }
                return ((Number)value).intValue();
            }
            case "smallint": {
                if (value instanceof String) {
                    return Short.parseShort((String)value);
                }
                return ((Number)value).shortValue();
            }
            case "tinyint": {
                if (value instanceof String) {
                    return Byte.parseByte((String)value);
                }
                return ((Number)value).byteValue();
            }
            case "double": {
                if (value instanceof String) {
                    return Double.parseDouble((String)value);
                }
                return ((Number)value).doubleValue();
            }
            case "real": {
                if (value instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)value));
                }
                return Float.valueOf(((Number)value).floatValue());
            }
            case "boolean": {
                if (value instanceof String) {
                    return Boolean.parseBoolean((String)value);
                }
                return (Boolean)value;
            }
            case "varchar": 
            case "json": 
            case "time": 
            case "time with time zone": 
            case "timestamp": 
            case "timestamp with time zone": 
            case "date": 
            case "interval year to month": 
            case "interval day to second": 
            case "ipaddress": 
            case "uuid": 
            case "decimal": 
            case "char": 
            case "Geometry": 
            case "SphericalGeography": {
                return (String)value;
            }
            case "BingTile": {
                return value;
            }
        }
        if (value instanceof String) {
            return Base64.getDecoder().decode((String)value);
        }
        return value;
    }
}

