/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio.archive.zip;

import ca.vanzyl.provisio.archive.ExtendedArchiveEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class ExtendedZipArchiveEntry
extends ZipArchiveEntry
implements ExtendedArchiveEntry {
    private final ExtendedArchiveEntry entry;

    public ExtendedZipArchiveEntry(String entryName, ExtendedArchiveEntry entry) {
        super(entryName);
        this.entry = entry;
    }

    @Override
    public void setFileMode(int mode) {
        this.setUnixMode(mode);
    }

    @Override
    public int getFileMode() {
        return this.getUnixMode();
    }

    @Override
    public void writeEntry(OutputStream outputStream) throws IOException {
        this.entry.writeEntry(outputStream);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.entry.getInputStream();
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public String getSymbolicLinkPath() {
        return null;
    }

    @Override
    public boolean isHardLink() {
        return false;
    }

    @Override
    public String getHardLinkPath() {
        return null;
    }

    @Override
    public boolean isExecutable() {
        return false;
    }

    @Override
    public void setTime(long timeEpochMillis) {
        if (timeEpochMillis != -1L) {
            timeEpochMillis = ExtendedZipArchiveEntry.dosToJavaTime(timeEpochMillis, true);
        }
        super.setTime(timeEpochMillis);
    }

    static long dosToJavaTime(long time, boolean writeToArchive) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
        cal.setTimeInMillis(time);
        return time - (long)((cal.get(15) + cal.get(16)) * (writeToArchive ? 1 : -1));
    }
}

