/*
 * Decompiled with CFR 0.152.
 */
package io.takari.resources.filtering;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.Resource;
import io.takari.resources.filtering.AbstractResourceProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

class CopyResourcesProcessor
extends AbstractResourceProcessor {
    private final BuildContext buildContext;

    public CopyResourcesProcessor(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void process(File sourceDirectory, File targetDirectory, List<String> includes, List<String> excludes, String encoding) throws IOException {
        for (Resource input : this.buildContext.registerAndProcessInputs(sourceDirectory, includes, excludes)) {
            this.copyResource((Resource<File>)input, sourceDirectory, targetDirectory, null, encoding);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyResource(Resource<File> input, File sourceDirectory, File targetDirectory, Map<Object, Object> filterProperties, String encoding) throws IOException {
        File outputFile = CopyResourcesProcessor.relativize(sourceDirectory, targetDirectory, (File)input.getResource());
        Output output = input.associateOutput(outputFile);
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            FileInputStream is = new FileInputStream((File)input.getResource());
            try {
                try (OutputStream os = output.newOutputStream();){
                    ((InputStream)is).transferTo(os);
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

