/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile;

import io.takari.incrementalbuild.MessageSeverity;
import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.Resource;
import io.takari.incrementalbuild.ResourceMetadata;
import io.takari.incrementalbuild.spi.AbstractBuildContext;
import io.takari.incrementalbuild.spi.BuildContextEnvironment;
import io.takari.incrementalbuild.spi.DefaultBuildContextState;
import io.takari.incrementalbuild.spi.DefaultOutput;
import io.takari.incrementalbuild.spi.DefaultResource;
import io.takari.incrementalbuild.spi.DefaultResourceMetadata;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.project.MavenProject;

@Named
@MojoExecutionScoped
public class CompilerBuildContext
extends AbstractBuildContext {
    private final File pom;

    @Inject
    public CompilerBuildContext(BuildContextEnvironment configuration, MavenProject project) {
        super(configuration);
        this.pom = project.getFile();
    }

    public void markSkipExecution() {
        super.markSkipExecution();
    }

    public void markUptodateExecution() {
        for (File outputFile : this.oldState.getOutputs()) {
            this.markUptodateOutput(outputFile);
        }
    }

    public void markUptodateOutput(File outputFile) {
        super.markUptodateOutput(outputFile);
    }

    public void addPomMessage(String message, MessageSeverity severity, Throwable cause) {
        super.addMessage((Object)this.pom, 0, 0, message, severity, cause);
    }

    public boolean isEscalated() {
        return super.isEscalated();
    }

    public <V extends Serializable> V getAttribute(String key, boolean previous, Class<V> clazz) {
        return (V)super.getResourceAttribute(this.oldState, (Object)this.pom, key, clazz);
    }

    public <V extends Serializable> Serializable setAttribute(String key, V value) {
        return super.setResourceAttribute((Object)this.pom, key, value);
    }

    public Collection<DefaultResourceMetadata<File>> registerSources(File basedir, Collection<String> includes, Collection<String> excludes) throws IOException {
        return super.registerInputs(basedir, includes, excludes);
    }

    public Collection<ResourceMetadata<File>> getRemovedSources() {
        ArrayList<ResourceMetadata<File>> sources = new ArrayList<ResourceMetadata<File>>();
        for (Object resource : this.oldState.getResources().keySet()) {
            if (!CompilerBuildContext.isJavaSource(resource) || this.oldState.isOutput(resource) || this.isRegisteredResource(resource)) continue;
            sources.add((ResourceMetadata<File>)this.newResourceMetadata(this.oldState, (File)resource));
        }
        return sources;
    }

    public Resource<File> getProcessedSource(File sourceFile) {
        if (!this.isProcessedResource(sourceFile) || !CompilerBuildContext.isJavaSource(sourceFile)) {
            throw new IllegalArgumentException();
        }
        return this.newResource(sourceFile);
    }

    public Collection<ResourceMetadata<File>> getRegisteredSources() {
        ArrayList<ResourceMetadata<File>> sources = new ArrayList<ResourceMetadata<File>>();
        for (Object resource : this.state.getResources().keySet()) {
            if (!CompilerBuildContext.isJavaSource(resource)) continue;
            DefaultBuildContextState state = this.isProcessedResource(resource) ? this.state : this.oldState;
            sources.add((ResourceMetadata<File>)this.newResourceMetadata(state, (File)resource));
        }
        return sources;
    }

    public static boolean isJavaSource(Object resource) {
        return resource instanceof File && ((File)resource).getName().endsWith(".java");
    }

    public <V extends Serializable> V getAttribute(File source, String key, Class<V> clazz) {
        return (V)this.getResourceAttribute(this.getState(source), source, key, clazz);
    }

    private DefaultBuildContextState getState(File source) {
        return this.isProcessedResource(source) ? this.state : this.oldState;
    }

    public <V extends Serializable> Serializable setAttribute(File source, String key, V value) {
        return this.setResourceAttribute(source, key, value);
    }

    public Collection<ResourceMetadata<File>> deleteOutputs() throws IOException {
        ArrayList<ResourceMetadata<File>> deleted = new ArrayList<ResourceMetadata<File>>();
        for (File outputFile : this.oldState.getOutputs()) {
            this.deleteOutput(outputFile);
            deleted.add((ResourceMetadata<File>)this.newResourceMetadata(this.oldState, outputFile));
        }
        return deleted;
    }

    public Collection<ResourceMetadata<File>> getAssociatedOutputs(ResourceMetadata<File> source) {
        return this.addAssociatedOutputs(new HashMap<File, ResourceMetadata<File>>(), source).values();
    }

    protected Collection<? extends ResourceMetadata<File>> getAssociatedOutputs(DefaultBuildContextState state, Object resource) {
        return super.getAssociatedOutputs(state, resource);
    }

    public Collection<ResourceMetadata<File>> getAssociatedOutputs(File source) {
        return super.getAssociatedOutputs(this.getState(source), (Object)source);
    }

    private Map<File, ResourceMetadata<File>> addAssociatedOutputs(Map<File, ResourceMetadata<File>> outputs, ResourceMetadata<File> resource) {
        for (ResourceMetadata output : super.getAssociatedOutputs(this.getState((File)resource.getResource()), resource.getResource())) {
            if (outputs.containsKey(output.getResource())) continue;
            outputs.put((File)output.getResource(), (ResourceMetadata<File>)output);
            this.addAssociatedOutputs(outputs, (ResourceMetadata<File>)output);
        }
        return outputs;
    }

    public DefaultOutput processOutput(File outputFile) {
        return super.processOutput(outputFile);
    }

    public Resource<File> processInput(ResourceMetadata<File> inputResource) {
        super.processResource(inputResource.getResource());
        return inputResource.process();
    }

    public void deleteOutput(File outputFile) throws IOException {
        super.deleteOutput(outputFile);
    }

    public boolean isProcessedOutput(File outputFile) {
        return this.state.isOutput((Object)outputFile) && this.isProcessedResource(outputFile);
    }

    public Output<File> associatedOutput(Resource<File> input, File outputFile) {
        return input.associateOutput(outputFile);
    }

    protected void assertAssociation(DefaultResource<?> resource, DefaultOutput output) {
    }

    protected void finalizeContext() {
        for (Object resource : this.oldState.getResources().keySet()) {
            if (this.isProcessedResource(resource) || this.isDeletedResource(resource) || !this.oldState.isOutput(resource) && !this.state.isResource(resource)) continue;
            this.state.putResource(resource, this.oldState.getResource(resource));
            if (this.oldState.isOutput(resource)) {
                this.state.addOutput((File)resource);
            }
            this.state.setResourceMessages(resource, this.oldState.getResourceMessages(resource));
            this.state.setResourceAttributes(resource, this.oldState.getResourceAttributes(resource));
            this.state.setResourceOutputs(resource, this.oldState.getResourceOutputs(resource));
        }
    }
}

