/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.builder.NameSet;
import org.eclipse.jdt.internal.core.builder.QualifiedNameSet;

class ReferenceCollection
implements Serializable {
    final Set<String> qualifiedNameReferences;
    final Set<String> simpleNameReferences;
    final Set<String> rootReferences;
    private static final char[][][] EmptyQualifiedNames = new char[0][][];
    private static final char[][] EmptySimpleNames = CharOperation.NO_CHAR_CHAR;
    private static final char[][][] WellKnownQualifiedNames = new char[][][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION, TypeConstants.JAVA_LANG_THROWABLE, TypeConstants.JAVA_LANG_OBJECT, TypeConstants.JAVA_LANG, new char[][]{TypeConstants.JAVA}, new char[][]{{'o', 'r', 'g'}}, new char[][]{{'c', 'o', 'm'}}, CharOperation.NO_CHAR_CHAR};
    private static final char[][] WellKnownSimpleNames = new char[][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION[2], TypeConstants.JAVA_LANG_THROWABLE[2], TypeConstants.JAVA_LANG_OBJECT[2], TypeConstants.JAVA, TypeConstants.LANG, {'o', 'r', 'g'}, {'c', 'o', 'm'}};
    private static final int MaxQualifiedNames = 7;
    private static QualifiedNameSet[] InternedQualifiedNames = new QualifiedNameSet[7];
    static final int MaxSimpleNames = 30;
    static NameSet[] InternedSimpleNames = new NameSet[30];

    static {
        int i = 0;
        while (i < 7) {
            ReferenceCollection.InternedQualifiedNames[i] = new QualifiedNameSet(37);
            ++i;
        }
        i = 0;
        while (i < 30) {
            ReferenceCollection.InternedSimpleNames[i] = new NameSet(37);
            ++i;
        }
    }

    public ReferenceCollection(char[][] rootReferences, char[][][] qualifiedNameReferences, char[][] simpleNameReferences) {
        this.qualifiedNameReferences = ImmutableSet.copyOf(this.toStringSet(qualifiedNameReferences));
        this.simpleNameReferences = ImmutableSet.copyOf(this.toStringSet(simpleNameReferences));
        this.rootReferences = ImmutableSet.copyOf(this.toStringSet(rootReferences));
    }

    public ReferenceCollection() {
        this.qualifiedNameReferences = new LinkedHashSet<String>();
        this.simpleNameReferences = new LinkedHashSet<String>();
        this.rootReferences = new LinkedHashSet<String>();
    }

    private Set<String> toStringSet(char[][] strings) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        char[][] cArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            char[] string = cArray[n2];
            set.add(new String(string));
            ++n2;
        }
        return set;
    }

    private Set<String> toStringSet(char[][][] arrays) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        char[][][] cArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            char[][] array = cArray[n2];
            set.add(CharOperation.toString((char[][])array));
            ++n2;
        }
        return set;
    }

    public boolean includes(Collection<String> qualifiedNames, Collection<String> simpleNames, Collection<String> rootNames) {
        if (rootNames != null) {
            boolean foundRoot = false;
            for (String rootName : rootNames) {
                foundRoot = this.rootReferences.contains(rootName);
                if (foundRoot) break;
            }
            if (!foundRoot) {
                return false;
            }
        }
        for (String simpleName : simpleNames) {
            if (!this.simpleNameReferences.contains(simpleName)) continue;
            for (String qualifiedName : qualifiedNames) {
                if (!(qualifiedName.indexOf(46) > 0 ? this.qualifiedNameReferences.contains(qualifiedName) : this.simpleNameReferences.contains(qualifiedName))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void addDependencies(Collection<String> typeNameDependencies) {
        Object qNames = new char[typeNameDependencies.size()][][];
        Iterator<String> typeNameDependency = typeNameDependencies.iterator();
        int i = 0;
        while (typeNameDependency.hasNext()) {
            qNames[i] = CharOperation.splitOn((char)'.', (char[])typeNameDependency.next().toCharArray());
            ++i;
        }
        qNames = ReferenceCollection.internQualifiedNames(qNames, false);
        i = ((char[][][])qNames).length;
        block1: while (--i >= 0) {
            char[][] qualifiedTypeName = qNames[i];
            while (!this.includes(qualifiedTypeName)) {
                if (!this.includes(qualifiedTypeName[qualifiedTypeName.length - 1])) {
                    this.simpleNameReferences.add(new String(qualifiedTypeName[qualifiedTypeName.length - 1]));
                }
                if (!this.insideRoot(qualifiedTypeName[0])) {
                    this.rootReferences.add(new String(qualifiedTypeName[0]));
                }
                this.qualifiedNameReferences.add(CharOperation.toString((char[][])qualifiedTypeName));
                qualifiedTypeName = CharOperation.subarray((char[][])qualifiedTypeName, (int)0, (int)(qualifiedTypeName.length - 1));
                char[][][] temp = ReferenceCollection.internQualifiedNames(new char[][][]{qualifiedTypeName}, false);
                if (temp == EmptyQualifiedNames) continue block1;
                qualifiedTypeName = temp[0];
            }
        }
    }

    private static char[][][] internQualifiedNames(char[][][] qualifiedNames, boolean keepWellKnown) {
        if (qualifiedNames == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedNames.length;
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] keepers = new char[length][][];
        int index = 0;
        int i = 0;
        while (i < length) {
            block8: {
                char[][] qualifiedName = qualifiedNames[i];
                int qLength = qualifiedName.length;
                int j = 0;
                int m = WellKnownQualifiedNames.length;
                while (j < m) {
                    char[][] wellKnownName = WellKnownQualifiedNames[j];
                    if (qLength > wellKnownName.length) break;
                    if (CharOperation.equals((char[][])qualifiedName, (char[][])wellKnownName)) {
                        if (keepWellKnown) {
                            keepers[index++] = wellKnownName;
                        }
                        break block8;
                    }
                    ++j;
                }
                QualifiedNameSet internedNames = InternedQualifiedNames[qLength <= 7 ? qLength - 1 : 0];
                qualifiedName = ReferenceCollection.internSimpleNames(qualifiedName, false);
                keepers[index++] = internedNames.add(qualifiedName);
            }
            ++i;
        }
        if (length > index) {
            if (index == 0) {
                return EmptyQualifiedNames;
            }
            char[][][] cArrayArray = keepers;
            keepers = new char[index][][];
            System.arraycopy(cArrayArray, 0, keepers, 0, index);
        }
        return keepers;
    }

    private static char[][] internSimpleNames(char[][] simpleNames, boolean removeWellKnown) {
        if (simpleNames == null) {
            return EmptySimpleNames;
        }
        int length = simpleNames.length;
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] keepers = new char[length][];
        int index = 0;
        int i = 0;
        while (i < length) {
            block8: {
                char[] name = simpleNames[i];
                int sLength = name.length;
                int j = 0;
                int m = WellKnownSimpleNames.length;
                while (j < m) {
                    char[] wellKnownName = WellKnownSimpleNames[j];
                    if (sLength > wellKnownName.length) break;
                    if (CharOperation.equals((char[])name, (char[])wellKnownName)) {
                        if (!removeWellKnown) {
                            keepers[index++] = WellKnownSimpleNames[j];
                        }
                        break block8;
                    }
                    ++j;
                }
                NameSet internedNames = InternedSimpleNames[sLength < 30 ? sLength : 0];
                keepers[index++] = internedNames.add(name);
            }
            ++i;
        }
        if (length > index) {
            if (index == 0) {
                return EmptySimpleNames;
            }
            char[][] cArrayArray = keepers;
            keepers = new char[index][];
            System.arraycopy(cArrayArray, 0, keepers, 0, index);
        }
        return keepers;
    }

    private boolean includes(char[][] qualifiedName) {
        return this.qualifiedNameReferences.contains(CharOperation.toString((char[][])qualifiedName));
    }

    private boolean includes(char[] simpleName) {
        return this.simpleNameReferences.contains(new String(simpleName));
    }

    private boolean insideRoot(char[] rootName) {
        return this.rootReferences.contains(new String(rootName));
    }
}

