/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import com.google.common.base.Stopwatch;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import io.takari.maven.plugins.compile.jdt.ClassfileDigester;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@MojoExecutionScoped
public class ClasspathDigester {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Map<File, Map<String, byte[]>> CACHE = new ConcurrentHashMap<File, Map<String, byte[]>>();
    private final ClassfileDigester digester;

    @Inject
    public ClasspathDigester(MavenProject project, MavenSession session, ClassfileDigester digester) {
        this.digester = digester;
        CACHE.remove(new File(project.getBuild().getOutputDirectory()));
        CACHE.remove(new File(project.getBuild().getTestOutputDirectory()));
    }

    public HashMap<String, byte[]> digestDependencies(List<File> dependencies) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        HashMap<String, byte[]> digest = new HashMap<String, byte[]>();
        int i = dependencies.size() - 1;
        while (i >= 0) {
            File file = dependencies.get(i);
            if (file.isFile()) {
                digest.putAll(this.digestJar(file));
            } else if (file.isDirectory()) {
                digest.putAll(this.digestDirectory(file));
            }
            --i;
        }
        this.log.debug("Analyzed {} classpath dependencies ({} ms)", (Object)dependencies.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return digest;
    }

    private Map<String, byte[]> digestJar(File file) throws IOException {
        Map<String, byte[]> digest = CACHE.get(file);
        if (digest == null) {
            digest = new HashMap<String, byte[]>();
            HashMap<String, byte[]> sourcesDigest = new HashMap<String, byte[]>();
            try (JarFile jar = new JarFile(file);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String type;
                    JarEntry entry = entries.nextElement();
                    String path = entry.getName();
                    if (path.endsWith(".class")) {
                        type = ClasspathDigester.toJavaType(path, ".class");
                        try {
                            digest.put(type, this.digester.digest((IBinaryType)ClassFileReader.read((ZipFile)jar, (String)path)));
                        }
                        catch (ClassFormatException classFormatException) {}
                        continue;
                    }
                    if (!path.endsWith(".java")) continue;
                    type = ClasspathDigester.toJavaType(path, ".java");
                    Hasher hasher = Hashing.sha1().newHasher();
                    Throwable throwable = null;
                    Object var11_12 = null;
                    try (InputStream in = jar.getInputStream(entry);){
                        ByteStreams.copy((InputStream)in, (OutputStream)Funnels.asOutputStream((PrimitiveSink)hasher));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    sourcesDigest.put(type, hasher.hash().asBytes());
                }
            }
            this.mergeAll(digest, sourcesDigest);
            CACHE.put(file, digest);
        }
        return digest;
    }

    private Map<String, byte[]> digestDirectory(File directory) throws IOException {
        Map<String, byte[]> digest = CACHE.get(directory);
        if (digest == null) {
            digest = new HashMap<String, byte[]>();
            HashMap<String, byte[]> sourcesDigest = new HashMap<String, byte[]>();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(directory);
            scanner.setIncludes(new String[]{"**/*.class", "**/*.java"});
            scanner.scan();
            String[] stringArray = scanner.getIncludedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String type;
                String path = stringArray[n2];
                if (path.endsWith(".class")) {
                    type = ClasspathDigester.toJavaType(path, ".class");
                    try {
                        digest.put(type, this.digester.digest((IBinaryType)ClassFileReader.read((File)new File(directory, path))));
                    }
                    catch (ClassFormatException classFormatException) {}
                } else {
                    type = ClasspathDigester.toJavaType(path, ".java");
                    sourcesDigest.put(type, Files.hash((File)new File(directory, path), (HashFunction)Hashing.sha1()).asBytes());
                }
                ++n2;
            }
            this.mergeAll(digest, sourcesDigest);
            CACHE.put(directory, digest);
        }
        return digest;
    }

    private void mergeAll(Map<String, byte[]> target, Map<String, byte[]> source) {
        for (Map.Entry<String, byte[]> entry : source.entrySet()) {
            byte[] value = target.get(entry.getKey());
            if (value != null) {
                byte[] temp = new byte[value.length + entry.getValue().length];
                System.arraycopy(value, 0, temp, 0, value.length);
                System.arraycopy(entry.getValue(), 0, temp, value.length, entry.getValue().length);
                value = temp;
            } else {
                value = entry.getValue();
            }
            target.put(entry.getKey(), value);
        }
    }

    public static String toJavaType(String path, String suffix) {
        path = path.substring(0, path.length() - suffix.length());
        return path.replace('/', '.').replace('\\', '.');
    }

    public static void flush() {
        CACHE.clear();
    }
}

