/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.timeline.buildevents;

import com.google.common.collect.Lists;
import io.takari.maven.timeline.Event;
import io.takari.maven.timeline.Timeline;
import io.takari.maven.timeline.TimelineSerializer;
import io.takari.maven.timeline.WebUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class BuildEventListener
extends AbstractExecutionListener {
    private final File mavenTimeline;
    private final File output;
    private final long start;
    private final Map<Execution, Metric> executionMetrics = new ConcurrentHashMap<Execution, Metric>();
    private final Map<Execution, Event> timelineMetrics = new ConcurrentHashMap<Execution, Event>();
    private final Map<Long, Long> threadToTrackNum = new ConcurrentHashMap<Long, Long>();
    private final Map<Long, Integer> threadNumToColour = new ConcurrentHashMap<Long, Integer>();
    private long trackNum = 1L;
    String startTime;
    String endTime;
    private static String[] colours = new String[]{"blue", "green"};

    public BuildEventListener(File output, File mavenTimeline) {
        this.output = output;
        this.mavenTimeline = mavenTimeline;
        this.start = System.currentTimeMillis();
        this.startTime = this.nowInUtc();
    }

    long millis() {
        return System.currentTimeMillis() - this.start;
    }

    public void mojoStarted(ExecutionEvent event) {
        Integer colour;
        Execution key = this.key(event);
        Long threadId = Thread.currentThread().getId();
        Long threadTrackNum = this.threadToTrackNum.get(threadId);
        if (threadTrackNum == null) {
            threadTrackNum = this.trackNum;
            this.threadToTrackNum.put(threadId, threadTrackNum);
            ++this.trackNum;
        }
        if ((colour = this.threadNumToColour.get(threadId)) == null) {
            colour = 0;
            this.threadNumToColour.put(threadId, colour);
        } else {
            colour = 1 - colour;
            this.threadNumToColour.put(threadId, colour);
        }
        this.executionMetrics.put(key, new Metric(key, Thread.currentThread().getId(), this.millis()));
        this.timelineMetrics.put(key, new Event(key.toString(), threadTrackNum, colours[colour], this.nowInUtc()));
    }

    String nowInUtc() {
        return new DateTime(DateTimeZone.UTC).toString();
    }

    public void mojoSkipped(ExecutionEvent event) {
        this.mojoEnd(event);
    }

    public void mojoSucceeded(ExecutionEvent event) {
        this.mojoEnd(event);
    }

    public void mojoFailed(ExecutionEvent event) {
        this.mojoEnd(event);
    }

    private void mojoEnd(ExecutionEvent event) {
        Event timelineMetric = this.timelineMetrics.get(this.key(event));
        Metric metric = this.executionMetrics.get(this.key(event));
        if (metric == null) {
            return;
        }
        metric.setEnd(this.millis());
        timelineMetric.setEnd(new DateTime(DateTimeZone.UTC).toString());
        timelineMetric.setDuration(this.millis());
    }

    public void sessionEnded(ExecutionEvent event) {
        try {
            this.report();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Execution key(ExecutionEvent event) {
        MojoExecution mojo = event.getMojoExecution();
        MavenProject project = event.getProject();
        return new Execution(project.getGroupId(), project.getArtifactId(), mojo.getLifecyclePhase(), mojo.getGoal(), mojo.getExecutionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report() throws IOException {
        File path = this.output.getParentFile();
        if (!path.isDirectory() && !path.mkdirs()) {
            throw new IOException("Unable to create " + path);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));){
            Metric.array(writer, this.executionMetrics.values());
        }
        this.exportTimeline();
    }

    private void exportTimeline() throws IOException {
        System.out.println("!!!!!!!!!!!!!!!!!!");
        System.out.println("Writing maven timeline to " + this.mavenTimeline);
        System.out.println("!!!!!!!!!!!!!!!!!!");
        this.endTime = this.nowInUtc();
        WebUtils.copyResourcesToDirectory(((Object)((Object)this)).getClass(), "timeline", this.mavenTimeline.getParentFile());
        try (BufferedWriter mavenTimelineWriter = new BufferedWriter(new FileWriter(this.mavenTimeline));){
            Timeline timeline = new Timeline(this.startTime, this.endTime, Lists.newArrayList(this.timelineMetrics.values()));
            TimelineSerializer.serialize(mavenTimelineWriter, timeline);
        }
    }

    static class Metric {
        final Execution execution;
        final Long threadId;
        final Long start;
        Long end;

        Metric(Execution execution, Long threadId, Long start) {
            this.execution = execution;
            this.threadId = threadId;
            this.start = start;
        }

        void setEnd(Long end) {
            this.end = end;
        }

        String toJSON() {
            return this.record(this.value("groupId", this.execution.groupId), this.value("artifactId", this.execution.artifactId), this.value("phase", this.execution.phase), this.value("goal", this.execution.goal), this.value("id", this.execution.id), this.value("threadId", this.threadId), this.value("start", this.start), this.value("end", this.end));
        }

        private String value(String key, String value) {
            return "\"" + key + "\":\"" + value + "\"";
        }

        private String value(String key, Long value) {
            return "\"" + key + "\":" + value + "";
        }

        private String record(String ... values) {
            StringBuilder b = new StringBuilder();
            b.append("{");
            for (String value : values) {
                b.append(value).append(",");
            }
            return b.deleteCharAt(b.length() - 1).append("}").toString();
        }

        static void array(Appendable a, Iterable<Metric> metrics) throws IOException {
            a.append("[");
            Iterator<Metric> it = metrics.iterator();
            if (it.hasNext()) {
                a.append(it.next().toJSON());
            }
            while (it.hasNext()) {
                a.append(",").append(it.next().toJSON());
            }
            a.append("]");
        }
    }

    static class Execution {
        final String groupId;
        final String artifactId;
        final String phase;
        final String goal;
        final String id;

        public Execution(String groupId, String artifactId, String phase, String goal, String id) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.phase = phase;
            this.goal = goal;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.goal == null ? 0 : this.goal.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.phase == null ? 0 : this.phase.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Execution other = (Execution)obj;
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            if (this.goal == null ? other.goal != null : !this.goal.equals(other.goal)) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.phase == null ? other.phase != null : !this.phase.equals(other.phase));
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.phase + ":" + this.goal + ":" + this.id;
        }
    }
}

