/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.timeline;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class WebUtils {
    public static void openUrl(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyResourcesToDirectory(File jar, String jarDirectory, File outputDirectory) throws IOException {
        try (JarFile fromJar = new JarFile(jar);){
            Enumeration<JarEntry> entries = fromJar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(jarDirectory + "/") || entry.isDirectory()) continue;
                File dest = new File(outputDirectory + "/" + entry.getName().substring(jarDirectory.length() + 1));
                File parent = dest.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                FileOutputStream out = new FileOutputStream(dest);
                Throwable throwable = null;
                try {
                    InputStream in = fromJar.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        ByteStreams.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
    }

    public static void copyResourcesToDirectory(Class<?> clazz, String jarDirectory, File outputDirectory) throws IOException {
        CodeSource src = clazz.getProtectionDomain().getCodeSource();
        if (src != null) {
            WebUtils.copyResourcesToDirectory(WebUtils.urlToFile(src.getLocation()), jarDirectory, outputDirectory);
        }
    }

    private static File urlToFile(URL url) {
        File f;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(url.getPath());
        }
        return f;
    }

    public void launch(String path, File jar, File outputDirectory) throws IOException {
        WebUtils.copyResourcesToDirectory(jar, "timeline", outputDirectory);
        WebUtils.openUrl(new File("/tmp/timeline/timeline.html").toURI().toURL().toExternalForm());
    }

    public static void main(String[] args) throws Exception {
        String path = "timeline/timeline.html";
        File jar = new File("/Users/jvanzyl/js/takari/maven-timeline/target/maven-timeline-1.4.jar");
        File outputDirectory = new File("/tmp/timeline");
        WebUtils w = new WebUtils();
        w.launch(path, jar, outputDirectory);
    }
}

