/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.timeline;

import io.takari.maven.timeline.buildevents.BuildEventListener;
import io.takari.maven.timeline.buildevents.ExecutionListenerChain;
import java.io.File;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.component.annotations.Component;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="buildevents")
public class BuildEventsExtension
extends AbstractMavenLifecycleParticipant {
    private static final String OUTPUT_FILE = "execution.metrics.output.file";
    private static final String DEFAULT_FILE_DESTINATION = "target/execution-metrics.json";

    public void afterProjectsRead(MavenSession session) {
        MavenExecutionRequest request = session.getRequest();
        ExecutionListener original = request.getExecutionListener();
        BuildEventListener listener = new BuildEventListener(this.logFile(session), this.mavenTimelineFile(session));
        ExecutionListenerChain chain = new ExecutionListenerChain(original, (ExecutionListener)listener);
        request.setExecutionListener((ExecutionListener)chain);
    }

    private File mavenTimelineFile(MavenSession session) {
        return new File(session.getExecutionRootDirectory(), "target/timeline/maven-timeline.json");
    }

    private File logFile(MavenSession session) {
        String path = session.getUserProperties().getProperty(OUTPUT_FILE, DEFAULT_FILE_DESTINATION);
        if (new File(path).isAbsolute()) {
            return new File(path);
        }
        String buildDir = session.getExecutionRootDirectory();
        return new File(buildDir, path);
    }

    public static void main(String[] args) {
        String output = new DateTime(DateTimeZone.UTC).toString();
        System.out.println(output);
    }
}

