/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp.key;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;

public class FilePrivateKeySource {
    public PGPSecretKey load(String keyFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream inputStream = new FileInputStream(keyFile);){
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)inputStream), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            Object pgpObject = pgpObjectFactory.nextObject();
            if (!(pgpObject instanceof PGPSecretKeyRing)) {
                throw new IOException(String.valueOf(keyFile) + " doesn't contain PGP private key");
            }
            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)pgpObject;
            return keyRing.getSecretKey();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

