/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.testing;

import io.takari.builder.IArtifactMetadata;
import io.takari.builder.IArtifactResources;
import io.takari.builder.ResolutionScope;
import io.takari.builder.enforcer.internal.EnforcerConfig;
import io.takari.builder.internal.BuilderContext;
import io.takari.builder.internal.BuilderInputs;
import io.takari.builder.internal.BuilderRunner;
import io.takari.builder.internal.ClasspathMatcher;
import io.takari.builder.internal.JvmClasspathEntriesSupplier;
import io.takari.builder.internal.Reflection;
import io.takari.builder.internal.ResourceRoot;
import io.takari.builder.internal.digest.ClasspathDigester;
import io.takari.builder.internal.model.BuilderMethod;
import io.takari.builder.internal.resolver.DependencyResolver;
import io.takari.builder.internal.workspace.FilesystemWorkspace;
import io.takari.builder.testing.BuilderExecutionException;
import io.takari.builder.testing.BuilderExecutionResult;
import io.takari.builder.testing.BuilderRuntime;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuilderExecution {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File projectBasedir;
    private final Class<?> builderType;
    private final String goal;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Xpp3Dom configuration = new Xpp3Dom("configuration");
    private final Map<IArtifactMetadata, Path> dependencies = new LinkedHashMap<IArtifactMetadata, Path>();
    private final Map<IArtifactMetadata, Path> allDependencies = new LinkedHashMap<IArtifactMetadata, Path>();
    private final Map<String, BuilderInputs.Value<?>> forcedParameters = new LinkedHashMap();
    private final ClasspathMatcher classpathMatcher = new ClasspathMatcher(Arrays.asList(new JvmClasspathEntriesSupplier()));
    private final DependencyResolver dependencyResolver = new DependencyResolver(){

        @Override
        public Map<IArtifactMetadata, Path> getProjectDependencies(boolean transitive, ResolutionScope scope) {
            if (transitive) {
                return Collections.unmodifiableMap(BuilderExecution.this.allDependencies);
            }
            return Collections.unmodifiableMap(BuilderExecution.this.dependencies);
        }

        @Override
        public Map.Entry<IArtifactMetadata, Path> getProjectDependency(String groupId, String artifactId, String classifier, ResolutionScope scope) {
            for (Map.Entry<IArtifactMetadata, Path> entry : BuilderExecution.this.allDependencies.entrySet()) {
                IArtifactMetadata key = (IArtifactMetadata)entry.getKey();
                if (!this.eq(groupId, key.getGroupId()) || !this.eq(artifactId, key.getArtifactId()) || !this.eq(classifier, key.getClassifier())) continue;
                return entry;
            }
            return null;
        }

        private boolean eq(String a, String b) {
            return a != null ? a.equals(b) : b == null;
        }
    };
    private EnforcerConfig enforcerConfig = EnforcerConfig.empty();
    private Workspace workspace = new FilesystemWorkspace();
    private File stateFile;
    final List<ResourceRoot> projectResources = new ArrayList<ResourceRoot>();
    final List<String> compileSourceRoots = new ArrayList<String>();
    final List<String> testCompileSourceRoots = new ArrayList<String>();
    List<File> classpath = Collections.emptyList();

    public BuilderExecution(File projectBasedir, Class<?> builderType, String goal) {
        this.projectBasedir = projectBasedir;
        this.builderType = builderType;
        this.goal = goal;
    }

    public static BuilderExecution builderExecution(File projectBasedir, Class<?> builder, String goal) {
        return new BuilderExecution(projectBasedir, builder, goal);
    }

    public static BuilderExecution builderExecution(File projectBasedir, Class<?> builder) {
        List<BuilderMethod> builders = Reflection.createBuilderClass(builder).builders();
        Assert.assertEquals((String)"Ambiguous builder method", (long)1L, (long)builders.size());
        return BuilderExecution.builderExecution(projectBasedir, builder, builders.get(0).annotation().name());
    }

    public BuilderExecution withProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public BuilderExecution withConfiguration(String name, String value) {
        this.configuration.addChild(this.createXpp3Dom(name, value));
        return this;
    }

    public BuilderExecution withCompileSourceRoot(File compileSourceRoot) {
        this.compileSourceRoots.add(compileSourceRoot.getAbsolutePath());
        return this;
    }

    public BuilderExecution withTestCompileSourceRoot(File compileSourceRoot) {
        this.testCompileSourceRoots.add(compileSourceRoot.getAbsolutePath());
        return this;
    }

    BuilderExecution withStateFile(File stateFile) {
        this.stateFile = stateFile;
        return this;
    }

    BuilderExecution withClasspath(List<File> classpath) {
        this.classpath = new ArrayList<File>(classpath);
        return this;
    }

    public BuilderExecution withConfiguration(String name, Collection<String> values) {
        Xpp3Dom childConfiguration = new Xpp3Dom(name);
        values.stream().forEach(value -> childConfiguration.addChild(this.createXpp3Dom("value", (String)value)));
        this.configuration.addChild(childConfiguration);
        return this;
    }

    public BuilderExecutionResult execute() throws BuilderExecutionException {
        BuilderRuntime.enterTestScope();
        try {
            BuilderExecutionResult builderExecutionResult = this.executeWithoutRuntime();
            return builderExecutionResult;
        }
        finally {
            BuilderRuntime.leaveTestScope();
        }
    }

    BuilderExecutionResult executeWithoutRuntime() throws BuilderExecutionException {
        BuilderContext context = BuilderRunner.create(this.log, this.builderType, this.goal).setProjectBasedir(this.projectBasedir != null ? this.projectBasedir.toPath() : null).setStateFile(this.stateFile != null ? this.stateFile.toPath() : null).setProjectProperties(p -> this.properties.get(p)).setSessionClasspathMatcher(this.classpathMatcher.getMatcher()).setConfiguration(this.configuration).setDefaultMessageLocation(this.projectBasedir != null ? this.projectBasedir.toPath() : null, -1, -1).setProjectResourcesConsumer(resourceRoot -> {
            boolean bl = this.projectResources.add((ResourceRoot)resourceRoot);
        }).setProjectCompileSourceRoots(this.compileSourceRoots).setProjectTestCompileSourceRoots(this.testCompileSourceRoots).setDependencyResolver(this.dependencyResolver).setForcedParameters(this.forcedParameters).setBuilderEnforcerConfig(this.enforcerConfig).setClasspath(this.classpath.stream().map(f -> f.toPath()).collect(Collectors.toList()), new ClasspathDigester()).setBuilderId(this.goal).setWorkspace(this.workspace).execute(BuilderExecutionException::new);
        return new BuilderExecutionResult(this, context);
    }

    private Xpp3Dom createXpp3Dom(String name, String value) {
        Xpp3Dom dom = new Xpp3Dom(name);
        dom.setValue(value);
        return dom;
    }

    public BuilderExecution withConfigurationXml(String name, String xml) throws XmlPullParserException, IOException {
        this.configuration.addChild(Xpp3DomBuilder.build((Reader)new StringReader(String.format("<%s>%s</%s>", name, xml, name))));
        return this;
    }

    public BuilderExecution withInputDirectory(String name, File location) throws XmlPullParserException, IOException {
        StringReader xml = new StringReader(String.format("<%s><location>%s</location></%s>", name, location.getCanonicalPath(), name));
        this.configuration.addChild(Xpp3DomBuilder.build((Reader)xml));
        return this;
    }

    public BuilderExecution withInputDirectory(String name, File location, Collection<String> includes) throws XmlPullParserException, IOException {
        StringBuilder xml = new StringBuilder();
        xml.append("<").append(name).append(">");
        xml.append("<location>").append(location.getCanonicalPath()).append("</location>");
        xml.append("<includes>");
        includes.forEach(i -> {
            StringBuilder stringBuilder2 = xml.append("<include>").append((String)i).append("</include>");
        });
        xml.append("</includes>");
        xml.append("</").append(name).append(">");
        this.configuration.addChild(Xpp3DomBuilder.build((Reader)new StringReader(xml.toString())));
        return this;
    }

    public BuilderExecution withParameterValue(String parameter, Object value) {
        this.forcedParameters.put(parameter, new TestValue(value));
        return this;
    }

    public BuilderExecution withDependency(String coords, File content) {
        this.dependencies.put(BuilderExecution.newArtifactMetadata(coords), content.toPath());
        this.allDependencies.put(BuilderExecution.newArtifactMetadata(coords), content.toPath());
        return this;
    }

    public BuilderExecution withTransitiveDependency(String coords, File content) {
        this.allDependencies.put(BuilderExecution.newArtifactMetadata(coords), content.toPath());
        return this;
    }

    public BuilderExecution withEnforcerConfig(EnforcerConfig enforcerConfig) {
        this.enforcerConfig = enforcerConfig;
        return this;
    }

    BuilderExecution withWorkspace(Workspace workspace) {
        this.workspace = workspace;
        return this;
    }

    public static IArtifactMetadata newArtifactMetadata(String coords) {
        String version;
        String classifier;
        String type;
        String[] parts = coords.split(":");
        final String groupId = parts[0];
        final String artifactId = parts[1];
        if (parts.length == 3) {
            type = "jar";
            classifier = null;
            version = parts[2];
        } else if (parts.length == 4) {
            type = "jar";
            classifier = parts[2];
            version = parts[3];
        } else if (parts.length == 5) {
            type = parts[2];
            classifier = parts[3];
            version = parts[4];
        } else {
            throw new IllegalArgumentException();
        }
        return new IArtifactMetadata(){

            @Override
            public String getVersion() {
                return version;
            }

            @Override
            public String getType() {
                return type;
            }

            @Override
            public String getGroupId() {
                return groupId;
            }

            @Override
            public String getClassifier() {
                return classifier;
            }

            @Override
            public String getArtifactId() {
                return artifactId;
            }
        };
    }

    public static IArtifactResources newArtifactResources(String coords, URL ... resources) {
        final IArtifactMetadata artifact = BuilderExecution.newArtifactMetadata(coords);
        final LinkedHashSet<URL> urls = new LinkedHashSet<URL>(Arrays.asList(resources));
        return new IArtifactResources(){

            @Override
            public IArtifactMetadata artifact() {
                return artifact;
            }

            @Override
            public Set<URL> resources() {
                return urls;
            }
        };
    }

    static class TestValue
    implements BuilderInputs.Value<Object> {
        private final Object value;

        public TestValue(Object value) {
            this.value = value;
        }

        @Override
        public Object value() throws ReflectiveOperationException {
            return this.value;
        }
    }
}

