/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.model;

import io.takari.builder.Parameter;
import io.takari.builder.internal.model.AbstractParameter;
import io.takari.builder.internal.model.BuilderMetadataVisitor;
import io.takari.builder.internal.model.MemberAdapter;
import io.takari.builder.internal.model.TypeAdapter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class SimpleParameter
extends AbstractParameter {
    private static final String[] EMPTY = new String[0];
    private final Parameter annotation;
    static final Map<String, Function<String, ?>> converters;

    static {
        LinkedHashMap<String, Function<String, Object>> _converters = new LinkedHashMap<String, Function<String, Object>>();
        _converters.put(String.class.getCanonicalName(), s -> s);
        _converters.put(Boolean.class.getCanonicalName(), Boolean::valueOf);
        _converters.put(Boolean.TYPE.getCanonicalName(), Boolean::parseBoolean);
        _converters.put(Integer.TYPE.getCanonicalName(), Integer::parseInt);
        _converters.put(Integer.class.getCanonicalName(), Integer::parseInt);
        _converters.put(Long.TYPE.getCanonicalName(), Long::parseLong);
        _converters.put(Long.class.getCanonicalName(), Long::parseLong);
        _converters.put(URL.class.getCanonicalName(), s -> {
            try {
                return new URL((String)s);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        });
        _converters.put(URI.class.getCanonicalName(), s -> {
            try {
                return new URI((String)s);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        });
        converters = Collections.unmodifiableMap(_converters);
    }

    SimpleParameter(MemberAdapter element, TypeAdapter type) {
        super(element, type);
        this.annotation = element.getAnnotation(Parameter.class);
    }

    @Override
    public Parameter annotation() {
        return this.annotation;
    }

    @Override
    public boolean required() {
        return this.annotation != null ? this.annotation.required() : false;
    }

    public String[] value() {
        return this.annotation != null ? this.annotation.value() : EMPTY;
    }

    public String[] defaultValue() {
        return this.annotation != null ? this.annotation.defaultValue() : EMPTY;
    }

    @Override
    public void accept(BuilderMetadataVisitor visitor) {
        visitor.visitSimple(this);
    }

    public static boolean isSimpleType(TypeAdapter type) {
        return converters.containsKey(type.qualifiedName());
    }

    public static Function<String, ?> getConverter(TypeAdapter type) {
        Function<String, ?> converter = converters.get(type.qualifiedName());
        assert (converter != null);
        return converter;
    }
}

