/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.model;

import io.takari.builder.ArtifactResources;
import io.takari.builder.Builder;
import io.takari.builder.Dependencies;
import io.takari.builder.DependencyResources;
import io.takari.builder.GeneratedResourcesDirectory;
import io.takari.builder.GeneratedSourcesDirectory;
import io.takari.builder.InputDirectory;
import io.takari.builder.InputDirectoryFiles;
import io.takari.builder.InputFile;
import io.takari.builder.OutputDirectory;
import io.takari.builder.OutputFile;
import io.takari.builder.Parameter;
import io.takari.builder.internal.model.AbstractParameter;
import io.takari.builder.internal.model.ArtifactResourcesParameter;
import io.takari.builder.internal.model.BuilderMetadataVisitor;
import io.takari.builder.internal.model.BuilderMethod;
import io.takari.builder.internal.model.CompositeParameter;
import io.takari.builder.internal.model.DependenciesParameter;
import io.takari.builder.internal.model.DependencyResourcesParameter;
import io.takari.builder.internal.model.GeneratedResourcesDirectoryParameter;
import io.takari.builder.internal.model.GeneratedSourcesDirectoryParameter;
import io.takari.builder.internal.model.InputDirectoryFilesParameter;
import io.takari.builder.internal.model.InputDirectoryParameter;
import io.takari.builder.internal.model.InputFileParameter;
import io.takari.builder.internal.model.MapParameter;
import io.takari.builder.internal.model.MemberAdapter;
import io.takari.builder.internal.model.MethodAdapter;
import io.takari.builder.internal.model.MultivalueParameter;
import io.takari.builder.internal.model.OutputDirectoryParameter;
import io.takari.builder.internal.model.OutputFileParameter;
import io.takari.builder.internal.model.SimpleParameter;
import io.takari.builder.internal.model.TypeAdapter;
import io.takari.builder.internal.model.UnsupportedCollectionParameter;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class BuilderClass {
    private final TypeAdapter type;
    private final List<BuilderMethod> builders;
    private final List<AbstractParameter> parameters;
    private static Collection<Class<? extends Annotation>> all_annotations;
    private static Collection<Class<? extends Annotation>> parameter_annotations;

    static {
        ArrayList<Class<Parameter>> _parameters = new ArrayList<Class<Parameter>>();
        _parameters.add(Dependencies.class);
        _parameters.add(DependencyResources.class);
        _parameters.add(ArtifactResources.class);
        _parameters.add(GeneratedResourcesDirectory.class);
        _parameters.add(GeneratedSourcesDirectory.class);
        _parameters.add(InputDirectory.class);
        _parameters.add(InputDirectoryFiles.class);
        _parameters.add(InputFile.class);
        _parameters.add(OutputFile.class);
        _parameters.add(OutputDirectory.class);
        _parameters.add(Parameter.class);
        parameter_annotations = Collections.unmodifiableCollection(_parameters);
        ArrayList<Class<Builder>> _all = new ArrayList<Class<Builder>>(_parameters);
        _all.add(Builder.class);
        all_annotations = Collections.unmodifiableCollection(_all);
    }

    public BuilderClass(TypeAdapter type, List<BuilderMethod> builders, List<AbstractParameter> parameters) {
        this.type = type;
        this.builders = Collections.unmodifiableList(builders);
        this.parameters = Collections.unmodifiableList(parameters);
    }

    public TypeAdapter type() {
        return this.type;
    }

    public List<AbstractParameter> parameters() {
        return this.parameters;
    }

    public List<BuilderMethod> builders() {
        return this.builders;
    }

    public void accept(BuilderMetadataVisitor visitor) {
        if (visitor.enterBuilderClass(this)) {
            this.parameters.forEach(p -> p.accept(visitor));
            this.builders.forEach(b -> b.accept(visitor));
            visitor.leaveBuilderClass(this);
        }
    }

    public static Collection<Class<? extends Annotation>> annotations() {
        return all_annotations;
    }

    public static Collection<Class<? extends Annotation>> parameterAnnotations() {
        return parameter_annotations;
    }

    private static AbstractParameter createParameterMetadata(MemberAdapter field, TypeAdapter fieldType) {
        AbstractParameter node;
        if (fieldType.isArray() || fieldType.isIterable() && !fieldType.isSameType(Path.class)) {
            List<TypeAdapter> elementTypes = field.getParameterTypes();
            if (elementTypes.size() == 1 && (!elementTypes.get(0).isIterable() || elementTypes.get(0).isSameType(Path.class))) {
                TypeAdapter elementType = elementTypes.get(0);
                if (field.isAnnotationPresent(DependencyResources.class)) {
                    node = new DependencyResourcesParameter(field, elementType);
                } else if (field.isAnnotationPresent(ArtifactResources.class)) {
                    node = new ArtifactResourcesParameter(field, elementType);
                } else if (field.isAnnotationPresent(InputDirectoryFiles.class)) {
                    node = new InputDirectoryFilesParameter(field, elementType);
                } else if (field.isAnnotationPresent(Dependencies.class)) {
                    node = new DependenciesParameter(field, elementType);
                } else {
                    AbstractParameter members = BuilderClass.createParameterMetadata(field, elementType);
                    node = new MultivalueParameter(field, fieldType, members);
                }
            } else {
                node = new UnsupportedCollectionParameter(field, fieldType, elementTypes);
            }
        } else if (fieldType.isMap()) {
            List<TypeAdapter> elementTypes;
            node = field.isAnnotationPresent(Dependencies.class) ? ((elementTypes = field.getParameterTypes()).size() == 2 && (elementTypes.get(1).isSameType(Path.class) || elementTypes.get(1).isSameType(File.class)) ? new DependenciesParameter(field, fieldType, elementTypes.get(1)) : new UnsupportedCollectionParameter(field, fieldType, elementTypes)) : new MapParameter(field, fieldType);
        } else if (field.isAnnotationPresent(DependencyResources.class)) {
            node = new DependencyResourcesParameter(field, fieldType);
        } else if (field.isAnnotationPresent(ArtifactResources.class)) {
            node = new ArtifactResourcesParameter(field, fieldType);
        } else if (field.isAnnotationPresent(InputDirectoryFiles.class)) {
            node = new InputDirectoryFilesParameter(field, fieldType);
        } else if (field.isAnnotationPresent(InputDirectory.class)) {
            node = new InputDirectoryParameter(field, fieldType);
        } else if (field.isAnnotationPresent(OutputDirectory.class)) {
            node = new OutputDirectoryParameter(field, fieldType);
        } else if (field.isAnnotationPresent(OutputFile.class)) {
            node = new OutputFileParameter(field, fieldType);
        } else if (field.isAnnotationPresent(GeneratedResourcesDirectory.class)) {
            node = new GeneratedResourcesDirectoryParameter(field, fieldType);
        } else if (field.isAnnotationPresent(GeneratedSourcesDirectory.class)) {
            node = new GeneratedSourcesDirectoryParameter(field, fieldType);
        } else if (field.isAnnotationPresent(InputFile.class)) {
            node = new InputFileParameter(field, fieldType);
        } else if (fieldType.isEnum() || SimpleParameter.isSimpleType(fieldType)) {
            node = new SimpleParameter(field, fieldType);
        } else {
            ArrayList<AbstractParameter> members = new ArrayList<AbstractParameter>();
            fieldType.getAllMembers().forEach(m -> {
                boolean bl = members.add(BuilderClass.createParameterMetadata(m, m.getType()));
            });
            node = new CompositeParameter(field, fieldType, members);
        }
        return node;
    }

    private static boolean isParameter(MemberAdapter field) {
        return parameter_annotations.stream().anyMatch(a -> field.isAnnotationPresent((Class<? extends Annotation>)a));
    }

    public static <E> BuilderClass create(TypeAdapter type) {
        List<BuilderMethod> builders = type.getMethods().stream().filter(m -> m.getAnnotation(Builder.class) != null).map(m -> new BuilderMethod((MethodAdapter)m, type)).collect(Collectors.toList());
        List<AbstractParameter> parameters = type.getAllMembers().stream().filter(m -> BuilderClass.isParameter(m)).map(m -> BuilderClass.createParameterMetadata(m, m.getType())).collect(Collectors.toList());
        return new BuilderClass(type, builders, parameters);
    }
}

