/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.maven;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;

public class Takari_MavenIncrementalConventions {
    public static Path getExecutionStateLocation(MavenProject project, MojoExecution execution) {
        Path stateDirectory = Takari_MavenIncrementalConventions.getProjectStateLocation(project);
        return Takari_MavenIncrementalConventions.getExecutionStateLocationForDirectory(execution, stateDirectory);
    }

    private static Path getExecutionStateLocationForDirectory(MojoExecution execution, Path stateDirectory) {
        String builderId = Takari_MavenIncrementalConventions.getExecutionId(execution);
        return stateDirectory.resolve(builderId);
    }

    public static String getExecutionId(MojoExecution execution) {
        PluginDescriptor pluginDescriptor = execution.getMojoDescriptor().getPluginDescriptor();
        StringBuilder builderId = new StringBuilder();
        builderId.append(pluginDescriptor.getGroupId()).append('_').append(pluginDescriptor.getArtifactId());
        builderId.append('_').append(execution.getGoal()).append('_').append(execution.getExecutionId());
        return builderId.toString();
    }

    public static Path getProjectStateLocation(MavenProject project) {
        return Paths.get(project.getBuild().getDirectory(), "incremental3");
    }
}

