/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.maven;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.maven.project.MavenProject;

public class MavenProjectPropertyResolver
implements Function<String, String> {
    private static final Map<String, Function<MavenProject, String>> EXPRESSIONS;
    private final MavenProject project;

    static {
        HashMap<String, Function<MavenProject, String>> expressions = new HashMap<String, Function<MavenProject, String>>();
        expressions.put("project.groupId", p -> p.getGroupId());
        expressions.put("project.artifactId", p -> p.getArtifactId());
        expressions.put("project.version", p -> p.getVersion());
        expressions.put("project.basedir", p -> p.getBasedir().getAbsolutePath());
        expressions.put("project.build.directory", p -> p.getBuild().getDirectory());
        expressions.put("project.build.outputDirectory", p -> p.getBuild().getOutputDirectory());
        expressions.put("project.build.testOutputDirectory", p -> p.getBuild().getTestOutputDirectory());
        EXPRESSIONS = Collections.unmodifiableMap(expressions);
    }

    public MavenProjectPropertyResolver(MavenProject project) {
        this.project = project;
    }

    @Override
    public String apply(String name) {
        if (this.project.getProperties().containsKey(name)) {
            return this.project.getProperties().getProperty(name);
        }
        Function<MavenProject, String> getter = EXPRESSIONS.get(name);
        if (getter != null) {
            return getter.apply(this.project);
        }
        return null;
    }
}

