/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.maven;

import io.takari.builder.IArtifactMetadata;
import io.takari.builder.ResolutionScope;
import io.takari.builder.internal.Dependency;
import io.takari.builder.internal.cache.ScopedProjectDependencyCache;
import io.takari.builder.internal.maven.MavenArtifactMetadata;
import io.takari.builder.internal.maven.ScopeBasedDependencyResolutionResult;
import io.takari.builder.internal.resolver.DependencyResolver;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;

public class MavenDependencyResolver
implements DependencyResolver {
    private final MavenProject project;
    private final RepositorySystemSession repoSession;
    private final RepositorySystem repositorySystem;
    private final ScopedProjectDependencyCache dependencyCache;

    public MavenDependencyResolver(MavenProject project, RepositorySystemSession repoSession, RepositorySystem repositorySystem, ScopedProjectDependencyCache dependencyCache) {
        this.project = project;
        this.repoSession = repoSession;
        this.repositorySystem = repositorySystem;
        this.dependencyCache = dependencyCache;
    }

    @Override
    public Map.Entry<IArtifactMetadata, Path> getProjectDependency(String groupId, String artifactId, String classifier, ResolutionScope scope) {
        Dependency dependency = new Dependency(groupId, artifactId, classifier);
        return this.resolveDependencies(scope, true).entrySet().stream().filter(a -> this.matchesArtifact(dependency, (IArtifactMetadata)a.getKey())).findFirst().get();
    }

    @Override
    public Map<IArtifactMetadata, Path> getProjectDependencies(boolean transitive, ResolutionScope scope) {
        return this.resolveDependencies(scope, transitive);
    }

    private boolean matchesArtifact(Dependency dependency, IArtifactMetadata a) {
        return dependency.matchesArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier());
    }

    private Map<IArtifactMetadata, Path> resolveDependencies(ResolutionScope scope, boolean transitive) {
        ScopedProjectDependencyCache.Key key = ScopedProjectDependencyCache.key(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), scope, transitive);
        return this.dependencyCache.getDependencies(key, () -> {
            Set<Artifact> artifacts = this.resolveArtifacts(scope, transitive);
            LinkedHashMap results = new LinkedHashMap();
            artifacts.forEach(a -> results.put(new MavenArtifactMetadata((Artifact)a), a.getFile().toPath()));
            return results;
        });
    }

    private Set<Artifact> resolveArtifacts(ResolutionScope scope, boolean transitive) {
        DependencyResolutionResult result;
        DependencyFilter resolutionFilter = this.getResolutionFilter(scope, transitive);
        try {
            result = this.resolveDependencies(scope, resolutionFilter);
        }
        catch (DependencyResolutionException e) {
            result = e.getResult();
        }
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        if (result.getDependencyGraph() != null && !result.getDependencyGraph().getChildren().isEmpty()) {
            RepositoryUtils.toArtifacts(artifacts, (Collection)result.getDependencyGraph().getChildren(), Collections.singletonList(this.project.getArtifact().getId()), (DependencyFilter)resolutionFilter);
        }
        return artifacts;
    }

    private DependencyFilter getResolutionFilter(ResolutionScope scope, boolean transitive) {
        ScopeDependencyFilter filter = new ScopeDependencyFilter(MavenDependencyResolver.impliedScopes(scope), null);
        if (!transitive) {
            filter = AndDependencyFilter.newInstance((DependencyFilter)filter, (DependencyFilter)new TransitiveDependencyFilter(this.project.getDependencies()));
        }
        return filter;
    }

    private static Collection<String> impliedScopes(ResolutionScope scope) {
        if (ResolutionScope.COMPILE.equals((Object)scope)) {
            return Arrays.asList("compile", "system", "provided");
        }
        if (ResolutionScope.RUNTIME.equals((Object)scope)) {
            return Arrays.asList("compile", "runtime");
        }
        if (ResolutionScope.COMPILE_PLUS_RUNTIME.equals((Object)scope)) {
            return Arrays.asList("compile", "system", "provided", "runtime");
        }
        if (ResolutionScope.TEST.equals((Object)scope)) {
            return Arrays.asList("compile", "system", "provided", "runtime", "test");
        }
        return Collections.emptyList();
    }

    private DependencyResolutionResult resolveDependencies(ResolutionScope scope, DependencyFilter resolutionFilter) throws DependencyResolutionException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            DependencyNode node;
            ClassRealm projectRealm = this.project.getClassRealm();
            if (projectRealm != null && projectRealm != tccl) {
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
            }
            RequestTrace trace = RequestTrace.newChild(null, (Object)resolutionFilter);
            ScopeBasedDependencyResolutionResult result = new ScopeBasedDependencyResolutionResult();
            ArtifactTypeRegistry stereotypes = this.repoSession.getArtifactTypeRegistry();
            CollectRequest collect = new CollectRequest();
            collect.setRootArtifact(RepositoryUtils.toArtifact((Artifact)this.project.getArtifact()));
            collect.setRequestContext("projectScope");
            collect.setRepositories(this.project.getRemoteProjectRepositories());
            for (org.apache.maven.model.Dependency dependency : this.project.getDependencies()) {
                if (StringUtils.isEmpty((String)dependency.getGroupId()) || StringUtils.isEmpty((String)dependency.getArtifactId()) || StringUtils.isEmpty((String)dependency.getVersion())) continue;
                collect.addDependency(RepositoryUtils.toDependency((org.apache.maven.model.Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
            }
            DependencyManagement depMngt = this.project.getDependencyManagement();
            if (depMngt != null) {
                for (org.apache.maven.model.Dependency dependency : depMngt.getDependencies()) {
                    collect.addManagedDependency(RepositoryUtils.toDependency((org.apache.maven.model.Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
                }
            }
            DependencyRequest depRequest = new DependencyRequest(collect, resolutionFilter);
            depRequest.setTrace(trace);
            collect.setTrace(RequestTrace.newChild((RequestTrace)trace, (Object)depRequest));
            try {
                node = this.repositorySystem.collectDependencies(this.repoSession, collect).getRoot();
                result.setDependencyGraph(node);
            }
            catch (DependencyCollectionException e) {
                result.setDependencyGraph(e.getResult().getRoot());
                e.printStackTrace();
                result.setCollectionErrors(e.getResult().getExceptions());
                throw new DependencyResolutionException((DependencyResolutionResult)result, "Could not resolve dependencies for project " + this.project.getId() + ", with scope " + (Object)((Object)scope) + ": " + e.getMessage(), (Throwable)e);
            }
            depRequest.setRoot(node);
            try {
                this.process(result, this.repositorySystem.resolveDependencies(this.repoSession, depRequest).getArtifactResults());
            }
            catch (org.eclipse.aether.resolution.DependencyResolutionException e) {
                e.printStackTrace();
                this.process(result, e.getResult().getArtifactResults());
                throw new DependencyResolutionException((DependencyResolutionResult)result, "Could not resolve dependencies for project " + this.project.getId() + ", with scope " + (Object)((Object)scope) + ": " + e.getMessage(), (Throwable)e);
            }
            ScopeBasedDependencyResolutionResult scopeBasedDependencyResolutionResult = result;
            return scopeBasedDependencyResolutionResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    private void process(ScopeBasedDependencyResolutionResult result, Collection<ArtifactResult> results) {
        for (ArtifactResult ar : results) {
            DependencyNode node = ar.getRequest().getDependencyNode();
            if (ar.isResolved()) {
                result.addResolvedDependency(node.getDependency());
                continue;
            }
            result.setResolutionErrors(node.getDependency(), ar.getExceptions());
        }
    }

    private static class TransitiveDependencyFilter
    implements DependencyFilter {
        private Set<String> keys = new HashSet<String>();

        public TransitiveDependencyFilter(Collection<org.apache.maven.model.Dependency> dependencies) {
            for (org.apache.maven.model.Dependency dependency : dependencies) {
                String key = ArtifactUtils.key((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion());
                this.keys.add(key);
            }
        }

        public boolean accept(DependencyNode node, List<DependencyNode> parents) {
            org.eclipse.aether.graph.Dependency dependency = node.getDependency();
            if (dependency != null) {
                org.eclipse.aether.artifact.Artifact a = dependency.getArtifact();
                String key = ArtifactUtils.key((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getVersion());
                return this.keys.contains(key);
            }
            return false;
        }
    }
}

