/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.Messages;
import io.takari.builder.internal.BuilderRunner;
import io.takari.builder.internal.Message;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

class MessageCollector
implements Messages {
    private final Logger log;
    private final Set<Message> messages = new LinkedHashSet<Message>();

    public MessageCollector(Logger log) {
        this.log = log;
    }

    private void collectAndLog(Message message) {
        this.collect(message);
        this.log(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collect(Message message) {
        Set<Message> set = this.messages;
        synchronized (set) {
            this.messages.add(message);
        }
    }

    private void log(Message message) {
        String resource = message.file;
        switch (message.severity) {
            case ERROR: {
                this.log.error("{}:[{},{}] {}", new Object[]{resource, message.line, message.column, message.message, message.cause});
                break;
            }
            case WARNING: {
                this.log.warn("{}:[{},{}] {}", new Object[]{resource, message.line, message.column, message.message, message.cause});
                break;
            }
            default: {
                this.log.info("{}:[{},{}] {}", new Object[]{resource, message.line, message.column, message.message, message.cause});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Message> getCollectedMessages() {
        Set<Message> set = this.messages;
        synchronized (set) {
            return new ArrayList<Message>(this.messages);
        }
    }

    <E extends Exception> void replayMessages(BuilderRunner.ExceptionFactory<E> efactory, List<Message> messages) throws E {
        messages.forEach(message -> this.collect((Message)message));
        this.throwExceptionIfThereWereErrorMessages(efactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E extends Exception> void throwExceptionIfThereWereErrorMessages(BuilderRunner.ExceptionFactory<E> efactory) throws E {
        Set<Message> set = this.messages;
        synchronized (set) {
            MessageCollector.assertBuildSuccess(efactory, this.messages);
        }
    }

    private static <E extends Exception> void assertBuildSuccess(BuilderRunner.ExceptionFactory<E> efactory, Collection<Message> messages) throws E {
        int errorCount = 0;
        StringBuilder errors = new StringBuilder();
        for (Message message : messages) {
            if (message.severity != Message.MessageSeverity.ERROR) continue;
            ++errorCount;
            errors.append(String.format("%s:[%d:%d] %s\n", message.file.toString(), message.line, message.column, message.message));
        }
        if (errorCount > 0) {
            throw efactory.exception(String.valueOf(errorCount) + " error(s) encountered:\n" + errors.toString(), null);
        }
    }

    @Override
    public void info(File resource, int line, int column, String message, Throwable cause) {
        this.collectAndLog(new Message(resource.toString(), line, column, message, Message.MessageSeverity.INFO, cause));
    }

    @Override
    public void warn(File resource, int line, int column, String message, Throwable cause) {
        this.collectAndLog(new Message(resource.toString(), line, column, message, Message.MessageSeverity.WARNING, cause));
    }

    @Override
    public void error(File resource, int line, int column, String message, Throwable cause) {
        this.collectAndLog(new Message(resource.toString(), line, column, message, Message.MessageSeverity.ERROR, cause));
    }

    @Override
    public void info(Path resource, int line, int column, String message, Throwable cause) {
        this.collectAndLog(new Message(resource.toString(), line, column, message, Message.MessageSeverity.INFO, cause));
    }

    @Override
    public void warn(Path resource, int line, int column, String message, Throwable cause) {
        this.collectAndLog(new Message(resource.toString(), line, column, message, Message.MessageSeverity.WARNING, cause));
    }

    @Override
    public void error(Path resource, int line, int column, String message, Throwable cause) {
        this.collectAndLog(new Message(resource.toString(), line, column, message, Message.MessageSeverity.ERROR, cause));
    }
}

