/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import java.io.Serializable;

public class Message
implements Serializable {
    public final String file;
    public final int line;
    public final int column;
    public final String message;
    public final MessageSeverity severity;
    public final Throwable cause;
    private final int hashCode;

    public Message(String file, int line, int column, String message, MessageSeverity severity, Throwable cause) {
        this.file = file;
        this.line = line;
        this.column = column;
        this.message = message;
        this.severity = severity;
        this.cause = cause;
        this.hashCode = this._hashCode();
    }

    private int _hashCode() {
        int result = 31;
        result = result * 17 + this.file.hashCode();
        result = result * 17 + this.line;
        result = result * 17 + this.column;
        result = result * 17 + (this.message != null ? this.message.hashCode() : 0);
        result = result * 17 + (this.severity != null ? this.severity.hashCode() : 0);
        result = result * 17 + (this.cause != null ? this.cause.hashCode() : 0);
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        return this.line == other.line && this.column == other.column && Message.eq(this.file, other.file) && Message.eq(this.message, other.message) && Message.eq(this.severity, other.severity) && Message.eq(this.cause, other.cause);
    }

    private static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    public static enum MessageSeverity {
        ERROR,
        WARNING,
        INFO;

    }
}

