/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.incrementalbuild.classpath.ClasspathEntriesSupplier;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.DefaultPlexusContainer;

@Named
@Singleton
public class MavenClasspathEntriesSupplier
implements ClasspathEntriesSupplier {
    private final Collection<String> classpath = new LinkedHashSet<String>();

    @Inject
    MavenClasspathEntriesSupplier(DefaultPlexusContainer plexus) {
        this.populateClasspath(plexus);
    }

    private void populateClasspath(DefaultPlexusContainer plexus) {
        plexus.getClassWorld().getRealms().stream().flatMap(r -> Arrays.asList(r.getURLs()).stream()).forEach(url -> {
            if ("file".equals(url.getProtocol())) {
                this.classpath.add(url.getPath());
            }
        });
    }

    public Collection<String> entries() {
        return this.classpath;
    }
}

