/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.internal.ExpressionEvaluationException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ExpressionEvaluator {
    private final List<Function<String, String>> resolvers;

    public String evaluate(String expression) throws ExpressionEvaluationException {
        StringBuilder result = new StringBuilder();
        int idx = 0;
        while (idx < expression.length() - 2) {
            String substitute;
            int to;
            int from = expression.indexOf(36, idx);
            if (from < 0) break;
            if (expression.charAt(from + 1) == '$') {
                to = from + 1;
                substitute = "$";
            } else {
                if (expression.charAt(from + 1) != '{' || (to = expression.indexOf("}", from)) < 0) break;
                substitute = this.substitute(expression.substring(from + 2, to));
            }
            result.append(expression.substring(idx, from));
            result.append(substitute);
            idx = to + 1;
        }
        if (idx < expression.length()) {
            result.append(expression.substring(idx));
        }
        return result.toString();
    }

    private String substitute(String property) throws ExpressionEvaluationException {
        for (Function<String, String> resolver : this.resolvers) {
            String resolved = resolver.apply(property);
            if (resolved == null) continue;
            return resolved;
        }
        throw new ExpressionEvaluationException("${" + property + "}");
    }

    public ExpressionEvaluator(List<Function<String, String>> resolvers) {
        for (Function<String, String> resolver : resolvers) {
            if (resolver != null) continue;
            throw new NullPointerException();
        }
        this.resolvers = new ArrayList<Function<String, String>>(resolvers);
    }
}

