/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.Messages;
import io.takari.builder.enforcer.ComposableSecurityManagerPolicy;
import io.takari.builder.enforcer.Policy;
import io.takari.builder.enforcer.internal.EnforcerViolation;
import io.takari.builder.enforcer.internal.EnforcerViolationType;
import io.takari.builder.internal.BuilderExecutionState;
import io.takari.builder.internal.BuilderWorkspace;
import io.takari.builder.internal.MessageCollector;
import io.takari.builder.internal.pathmatcher.FileMatcher;
import io.takari.builder.internal.pathmatcher.PathMatcher;
import io.takari.builder.internal.pathmatcher.PathNormalizer;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class BuilderContext {
    static final String PROPERTY_WRITE_ACTION = "write";
    static final String PROPERTY_READ_ACTION = "read";
    static final String PROPERTY_RW_ACTION = "read,write";
    private static final Object KEY_CONTEXT = BuilderContextPolicy.class;
    public static Messages MESSAGES = new Messages(){

        private Messages getCurrentMessages() {
            return BuilderContext.getCurrentContext().getMessages();
        }

        @Override
        public void warn(File resource, int line, int column, String message, Throwable cause) {
            this.getCurrentMessages().warn(resource, line, column, message, cause);
        }

        @Override
        public void info(File resource, int line, int column, String message, Throwable cause) {
            this.getCurrentMessages().info(resource, line, column, message, cause);
        }

        @Override
        public void error(File resource, int line, int column, String message, Throwable cause) {
            this.getCurrentMessages().error(resource, line, column, message, cause);
        }

        @Override
        public void warn(Path resource, int line, int column, String message, Throwable cause) {
            this.getCurrentMessages().warn(resource, line, column, message, cause);
        }

        @Override
        public void info(Path resource, int line, int column, String message, Throwable cause) {
            this.getCurrentMessages().info(resource, line, column, message, cause);
        }

        @Override
        public void error(Path resource, int line, int column, String message, Throwable cause) {
            this.getCurrentMessages().error(resource, line, column, message, cause);
        }
    };
    private final Logger log;
    private final String id;
    private final PathNormalizer normalizer;
    private final PathMatcher readMatcher;
    private final PathMatcher writeMatcher;
    private final PathMatcher tempMatcher;
    private final Collection<String> execExceptions;
    private final boolean networkAccessAllowed;
    private final FileMatcher readExceptionsMatcher;
    private final FileMatcher writeExceptionsMatcher;
    private final PathMatcher readAndTrackExceptionsMatcher;
    private final Set<EnforcerViolation> violations = ConcurrentHashMap.newKeySet();
    private final MessageCollector messages;
    private final BuilderWorkspace workspace;
    private final Object writeLock = new Object();
    private final BuilderExecutionState.InprogressStateWriter inprogressWriter;
    private final Set<String> writes = ConcurrentHashMap.newKeySet();
    private final Set<String> tempWrites = ConcurrentHashMap.newKeySet();
    private final Set<String> properties = ConcurrentHashMap.newKeySet();

    public void enter() {
        ComposableSecurityManagerPolicy.registerContextPolicy((Object)KEY_CONTEXT, (Policy)new BuilderContextPolicy(this));
    }

    public void leave() {
        BuilderContextPolicy policy = (BuilderContextPolicy)ComposableSecurityManagerPolicy.unregisterContextPolicy((Object)KEY_CONTEXT);
        if (policy.getBuilderContext() != this) {
            throw new IllegalStateException();
        }
        policy.inScope.set(false);
    }

    private static BuilderContext getCurrentContext() {
        BuilderContextPolicy policy = (BuilderContextPolicy)ComposableSecurityManagerPolicy.getContextPolicy((Object)KEY_CONTEXT);
        if (policy == null) {
            throw new IllegalStateException();
        }
        return policy.getBuilderContext();
    }

    public static Builder builder(Logger log, String id, Path sessionBasedir, MessageCollector messages, BuilderWorkspace workspace) {
        return new Builder(log, id, sessionBasedir, messages, workspace);
    }

    private BuilderContext(Logger log, PathNormalizer normalizer, String id, PathMatcher readMatcher, PathMatcher writeMatcher, PathMatcher tempMatcher, MessageCollector messages, Collection<String> execExceptions, boolean networkAccessAllowed, Collection<String> readExceptions, Collection<String> writeExceptions, PathMatcher readAndTrackExceptionsMatcher, BuilderExecutionState.InprogressStateWriter inprogressWriter, BuilderWorkspace workspace) {
        this.log = log;
        this.id = id;
        this.readMatcher = readMatcher;
        this.writeMatcher = writeMatcher;
        this.tempMatcher = tempMatcher;
        this.messages = messages;
        this.normalizer = normalizer;
        this.execExceptions = execExceptions;
        this.networkAccessAllowed = networkAccessAllowed;
        this.inprogressWriter = inprogressWriter;
        this.readExceptionsMatcher = BuilderContext.getExceptionsMatcher(readExceptions);
        this.writeExceptionsMatcher = BuilderContext.getExceptionsMatcher(writeExceptions);
        this.readAndTrackExceptionsMatcher = readAndTrackExceptionsMatcher;
        this.workspace = workspace;
    }

    private static FileMatcher getExceptionsMatcher(Collection<String> exceptions) {
        return exceptions != null && !exceptions.isEmpty() ? FileMatcher.createMatcher(exceptions, null) : FileMatcher.createMatcher(null, Arrays.asList("*"));
    }

    public String toString() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean checkRead(String file) {
        String normalized = this.normalizer.normalize(file);
        if (this.readExceptionsMatcher.matches(normalized) || this.readAndTrackExceptionsMatcher.includes(normalized)) {
            return true;
        }
        Object object = this.writeLock;
        synchronized (object) {
            block6: {
                if (!this.writes.contains(normalized) && !this.tempWrites.contains(normalized)) break block6;
                return true;
            }
            if (!this.readMatcher.includes(normalized)) {
                return !this.workspace.isRegularFile(PathNormalizer.toPath((String)normalized));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean checkAndRecordWrite(String file) {
        String normalized = this.normalizer.normalize(file);
        if (this.writeExceptionsMatcher.matches(normalized)) {
            return true;
        }
        Object object = this.writeLock;
        synchronized (object) {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            if (!this.writes.contains(normalized) && !this.tempWrites.contains(normalized)) break block8;
                            return true;
                        }
                        if (!this.workspace.isRegularFile(PathNormalizer.toPath((String)normalized)) || this.readAndTrackExceptionsMatcher.includes(normalized)) break block9;
                        return false;
                    }
                    if (!this.writeMatcher.includes(normalized)) break block10;
                    this.writes.add(normalized);
                    this.recordInprogressWrite(normalized);
                    this.workspace.processOutput(PathNormalizer.toPath((String)normalized));
                    return true;
                }
                if (!this.tempMatcher.includes(normalized)) break block11;
                this.tempWrites.add(normalized);
                this.recordInprogressWrite(normalized);
                return true;
            }
        }
        return false;
    }

    private void recordInprogressWrite(String normalized) {
        if (!this.readAndTrackExceptionsMatcher.includes(normalized)) {
            this.inprogressWriter.writePath(normalized);
        }
    }

    public final boolean checkExec(String command) {
        return this.execExceptions.contains(command);
    }

    public final boolean checkSockets() {
        return this.networkAccessAllowed;
    }

    public boolean checkAndRecordProperty(String action, String name) {
        if (action.equals(PROPERTY_READ_ACTION) || action.equals(PROPERTY_RW_ACTION)) {
            this.properties.add(name);
            return true;
        }
        return action.equals(PROPERTY_WRITE_ACTION);
    }

    public boolean addViolation(EnforcerViolation violation) {
        boolean added = this.violations.add(violation);
        if (added) {
            StringBuilder msg = new StringBuilder();
            msg.append(String.format("Access to an undeclared resource detected in builder: %s", this.toString()));
            msg.append("\n   " + violation.getFormattedViolation());
            violation.getStackTrace().forEach(s -> {
                StringBuilder stringBuilder2 = msg.append("\n   | ").append((String)s);
            });
            this.log.error(msg.toString());
        }
        return added;
    }

    public Set<EnforcerViolation> getViolations() {
        return this.violations;
    }

    public Collection<String> getWrittenFiles() {
        return this.writes;
    }

    public Collection<String> getTemporaryFiles() {
        return this.tempWrites;
    }

    public Collection<String> getReadProperties() {
        return this.properties;
    }

    public String getId() {
        return this.id;
    }

    public MessageCollector getMessages() {
        return this.messages;
    }

    public boolean wasWhitelistedException(String file) {
        return this.readAndTrackExceptionsMatcher.includes(this.normalizer.normalize(file));
    }

    /* synthetic */ BuilderContext(Logger logger, PathNormalizer pathNormalizer, String string, PathMatcher pathMatcher, PathMatcher pathMatcher2, PathMatcher pathMatcher3, MessageCollector messageCollector, Collection collection, boolean bl, Collection collection2, Collection collection3, PathMatcher pathMatcher4, BuilderExecutionState.InprogressStateWriter inprogressStateWriter, BuilderWorkspace builderWorkspace, BuilderContext builderContext) {
        this(logger, pathNormalizer, string, pathMatcher, pathMatcher2, pathMatcher3, messageCollector, collection, bl, collection2, collection3, pathMatcher4, inprogressStateWriter, builderWorkspace);
    }

    public static class Builder {
        private final Logger log;
        private final String id;
        private final Path sessionBasedir;
        private final PathNormalizer normalizer;
        private final PathMatcher.Builder readMatcherBuilder;
        private final PathMatcher.Builder readAndTrackMatcherBuilder;
        private final PathMatcher.Builder writeMatcherBuilder;
        private final PathMatcher.Builder tempMatcherBuilder;
        private final MessageCollector messages;
        private final Collection<String> execExceptions = new LinkedHashSet<String>();
        private boolean networkAccessAllowed;
        private final Collection<String> readExceptions = new LinkedHashSet<String>();
        private final Collection<String> writeExceptions = new LinkedHashSet<String>();
        private BuilderExecutionState.InprogressStateWriter inprogressWriter = BuilderExecutionState.NOOP_INPROGRESSWRITER;
        private final BuilderWorkspace workspace;

        private Builder(Logger log, String id, Path sessionBasedir, MessageCollector messages, BuilderWorkspace workspace) {
            this.log = log;
            this.id = id;
            this.sessionBasedir = sessionBasedir;
            this.messages = messages;
            this.normalizer = PathNormalizer.createNormalizer((Path)sessionBasedir);
            this.readMatcherBuilder = PathMatcher.builder((PathNormalizer)this.normalizer).excludeRoot();
            this.readAndTrackMatcherBuilder = PathMatcher.builder((PathNormalizer)this.normalizer).excludeRoot();
            this.writeMatcherBuilder = PathMatcher.builder((PathNormalizer)this.normalizer).excludeRoot();
            this.tempMatcherBuilder = PathMatcher.builder((PathNormalizer)this.normalizer).excludeRoot();
            this.workspace = workspace;
        }

        public Builder addInputMatcher(PathMatcher matcher) {
            this.readMatcherBuilder.addMatcher(matcher);
            return this;
        }

        public Builder addInputFiles(Collection<Path> inputFiles) {
            inputFiles.forEach(f -> {
                PathMatcher.Builder builder = this.readMatcherBuilder.includePath(f.toAbsolutePath().toString());
            });
            return this;
        }

        public Builder addInputFile(Path file) {
            this.readMatcherBuilder.includePath(file.toAbsolutePath().toString());
            return this;
        }

        public Builder addInputDirectory(Path directory) {
            this.readMatcherBuilder.includePrefix(directory.toAbsolutePath().toString());
            return this;
        }

        public Builder addOutputDirectory(Path directory) {
            String path = directory.toAbsolutePath().toString();
            this.writeMatcherBuilder.includePrefix(path);
            this.tempMatcherBuilder.excludePrefix(path);
            return this;
        }

        public Builder addOutputFile(Path file) {
            String path = file.toAbsolutePath().toString();
            this.writeMatcherBuilder.includePath(path);
            this.tempMatcherBuilder.excludePath(path);
            return this;
        }

        public Builder addTemporaryDirectory(Path directory) {
            String path = directory.toString();
            this.tempMatcherBuilder.includePrefix(path);
            this.writeMatcherBuilder.excludePrefix(path);
            return this;
        }

        public Builder addReadExceptions(Collection<String> readExceptions) {
            this.readExceptions.addAll(readExceptions);
            return this;
        }

        public Builder addReadAndTrackExceptions(Collection<String> exceptions) {
            exceptions.forEach(p -> {
                PathMatcher.Builder builder = this.readAndTrackMatcherBuilder.includePath(p);
            });
            return this;
        }

        public Builder addWriteExceptions(Collection<String> writeExceptions) {
            this.writeExceptions.addAll(writeExceptions);
            return this;
        }

        public Builder addExecExceptions(Collection<String> execExceptions) {
            this.execExceptions.addAll(execExceptions);
            return this;
        }

        public Builder setNetworkAccessAllowed(boolean networkAccessAllowed) {
            this.networkAccessAllowed = networkAccessAllowed;
            return this;
        }

        public Builder setInprogressWriter(BuilderExecutionState.InprogressStateWriter inprogressWriter) {
            this.inprogressWriter = inprogressWriter;
            return this;
        }

        public BuilderContext build() {
            this.tempMatcherBuilder.excludePrefix(PathNormalizer.normalize0((Path)this.sessionBasedir));
            PathMatcher readMatcher = this.readMatcherBuilder.build();
            PathMatcher writeMatcher = this.writeMatcherBuilder.build();
            PathMatcher tempMatcher = this.tempMatcherBuilder.build();
            PathMatcher readAndTrackExceptionsMatcher = this.readAndTrackMatcherBuilder.build();
            return new BuilderContext(this.log, this.normalizer, this.id, readMatcher, writeMatcher, tempMatcher, this.messages, this.execExceptions, this.networkAccessAllowed, this.readExceptions, this.writeExceptions, readAndTrackExceptionsMatcher, this.inprogressWriter, this.workspace, null);
        }
    }

    static class BuilderContextPolicy
    implements Policy {
        private final BuilderContext ctx;
        private final ThreadLocal<Boolean> readPrivileged = ThreadLocal.withInitial(() -> Boolean.FALSE);
        private AtomicBoolean inScope = new AtomicBoolean(true);

        public BuilderContextPolicy(BuilderContext ctx) {
            this.ctx = ctx;
        }

        public BuilderContext getBuilderContext() {
            return this.ctx;
        }

        public void checkWrite(String file) {
            this.checkScope();
            if (!this.ctx.checkAndRecordWrite(file)) {
                this.handleViolation(this.ctx, EnforcerViolationType.WRITE, PathNormalizer.normalize0((String)file));
            }
        }

        public void checkSocketPermission() {
            this.checkScope();
            if (!this.ctx.checkSockets()) {
                throw new SecurityException();
            }
        }

        public void checkRead(String file) {
            this.checkScope();
            if (this.readPrivileged.get() == Boolean.TRUE) {
                return;
            }
            try {
                this.readPrivileged.set(Boolean.TRUE);
                if (!this.ctx.checkRead(file)) {
                    this.handleViolation(this.ctx, EnforcerViolationType.READ, PathNormalizer.normalize0((String)file));
                }
            }
            finally {
                this.readPrivileged.set(Boolean.FALSE);
            }
        }

        public void checkPropertyPermission(String action, String name) {
            this.checkScope();
            if (!this.ctx.checkAndRecordProperty(action, name)) {
                throw new SecurityException();
            }
        }

        public void checkExec(String cmd) {
            this.checkScope();
            if (!this.ctx.checkExec(cmd)) {
                this.handleViolation(this.ctx, EnforcerViolationType.EXECUTE, cmd);
            }
        }

        private void checkScope() {
            if (!this.inScope.get()) {
                throw new IllegalStateException("BuilderContext is no longer in scope");
            }
        }

        private void handleViolation(BuilderContext ctx, EnforcerViolationType violationType, String path) {
            ctx.addViolation(new EnforcerViolation(violationType, path));
        }
    }
}

