/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal;

import io.takari.builder.IArtifactMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

class ArtifactResourceURLStreamHandler
extends URLStreamHandler {
    public static final String PROTOCOL = "artifactresource";
    private final URL resource;

    ArtifactResourceURLStreamHandler(URL resource) {
        this.resource = resource;
    }

    @Override
    protected URLConnection openConnection(URL url) {
        return new InputURLCollection(url);
    }

    public static URL newURL(IArtifactMetadata artifact, String relpath, URL resource) {
        try {
            StringBuilder host = new StringBuilder();
            host.append(artifact.getGroupId());
            host.append(':').append(artifact.getArtifactId());
            host.append(':').append(artifact.getVersion());
            if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
                host.append(':').append(artifact.getClassifier());
            }
            return new URL(PROTOCOL, host.toString(), -1, relpath, new ArtifactResourceURLStreamHandler(resource));
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    class InputURLCollection
    extends URLConnection {
        public InputURLCollection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return ArtifactResourceURLStreamHandler.this.resource.openStream();
        }
    }
}

