/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer;

import io.takari.builder.enforcer.CachingPolicy;
import io.takari.builder.enforcer.ExecCommandPassingSecurityManager;
import io.takari.builder.enforcer.Policy;
import io.takari.builder.enforcer.SimpleFilePermission;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.concurrent.ForkJoinPool;

public class ComposableSecurityManagerPolicy
extends java.security.Policy {
    private final SecurityManager originalManager;
    private final java.security.Policy originalPolicy;
    private volatile List<CachingPolicy> defaultPolicy;
    private final ThreadLocal<Map<Object, CachingPolicy>> contextPolicies = new ThreadLocal();
    private static volatile ComposableSecurityManagerPolicy policy;
    private final ThreadLocal<Boolean> privileged = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static final PermissionCollection allPermissions;

    static {
        allPermissions = new AllPermission().newPermissionCollection();
        allPermissions.add(new AllPermission());
        allPermissions.setReadOnly();
    }

    private static ComposableSecurityManagerPolicy setPolicy(SecurityManager originalManager) {
        java.security.Policy originalPolicy = java.security.Policy.getPolicy();
        if (originalPolicy instanceof ComposableSecurityManagerPolicy) {
            throw new IllegalStateException("Composable security manager policy has already been set.");
        }
        policy = new ComposableSecurityManagerPolicy(originalManager, originalPolicy);
        java.security.Policy.setPolicy(policy);
        return policy;
    }

    public ComposableSecurityManagerPolicy(SecurityManager originalManager, java.security.Policy originalPolicy) {
        this.originalManager = originalManager;
        this.originalPolicy = originalPolicy;
    }

    @Override
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        if (this.privileged.get() == Boolean.TRUE) {
            return true;
        }
        if ("setSecurityManager".equals(permission.getName()) || "setPolicy".equals(permission.getName())) {
            return false;
        }
        try {
            this.privileged.set(Boolean.TRUE);
            boolean bl = this.enforce(permission);
            return bl;
        }
        finally {
            this.privileged.set(Boolean.FALSE);
        }
    }

    private boolean enforce(Permission permission) {
        block23: {
            Collection<CachingPolicy> policies;
            block25: {
                block24: {
                    block22: {
                        policies = this.policies();
                        if (policies.isEmpty()) {
                            return true;
                        }
                        if (!(permission instanceof SimpleFilePermission.FileReadPermission)) break block22;
                        this.checkRead(policies, permission.getName());
                        break block23;
                    }
                    if (!(permission instanceof SimpleFilePermission.FileWritePermission)) break block24;
                    this.checkWrite(policies, permission.getName());
                    break block23;
                }
                if (!(permission instanceof FilePermission)) break block25;
                String fileName = permission.getName();
                String[] stringArray = ((FilePermission)permission).getActions().split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String actionSting;
                    switch (actionSting = stringArray[n2]) {
                        case "readlink": 
                        case "read": {
                            this.checkRead(policies, fileName);
                            break;
                        }
                        case "delete": 
                        case "write": {
                            this.checkWrite(policies, fileName);
                            break;
                        }
                        case "execute": {
                            policies.forEach(p -> p.checkExec(fileName));
                        }
                    }
                    ++n2;
                }
                break block23;
            }
            if (permission instanceof PropertyPermission) {
                policies.forEach(p -> p.checkPropertyPermission(permission.getActions(), permission.getName()));
            } else if (permission instanceof SocketPermission) {
                policies.forEach(p -> p.checkSocketPermission());
            }
        }
        return true;
    }

    protected void checkWrite(Collection<CachingPolicy> policies, String fileName) {
        policies.forEach(p -> p.checkWrite(fileName));
    }

    protected void checkRead(Collection<CachingPolicy> policies, String fileName) {
        policies.forEach(p -> p.checkRead(fileName));
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        System.out.println("Getting permissions domain :" + domain.getCodeSource());
        return java.security.Policy.UNSUPPORTED_EMPTY_COLLECTION;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource domain) {
        System.out.println("Getting permissions codesource :" + domain);
        return java.security.Policy.UNSUPPORTED_EMPTY_COLLECTION;
    }

    private static ComposableSecurityManagerPolicy get() {
        if (policy == null) {
            throw new IllegalStateException("Illegal System SecurityManager");
        }
        return policy;
    }

    private Collection<CachingPolicy> policies() {
        Map<Object, CachingPolicy> policies = this.contextPolicies.get();
        if (policies != null) {
            return policies.values();
        }
        if (this.defaultPolicy != null) {
            return this.defaultPolicy;
        }
        return Collections.emptyList();
    }

    static Map<Object, CachingPolicy> getContextPolicies() {
        Map<Object, CachingPolicy> policies = null;
        if (policy != null) {
            policies = ComposableSecurityManagerPolicy.policy.contextPolicies.get();
        }
        return policies != null ? new LinkedHashMap<Object, CachingPolicy>(policies) : null;
    }

    static void setContextPolicies(Map<Object, CachingPolicy> policies) {
        if (policy != null) {
            if (policies != null && !policies.isEmpty()) {
                ComposableSecurityManagerPolicy.policy.contextPolicies.set(new LinkedHashMap<Object, CachingPolicy>(policies));
            } else {
                ComposableSecurityManagerPolicy.policy.contextPolicies.set(null);
            }
        }
    }

    void registerPolicy(Object key, Policy policy) {
        Map<Object, CachingPolicy> policies = this.contextPolicies.get();
        if (policies != null && policies.containsKey(key)) {
            throw new IllegalArgumentException("Policy has already been registered.");
        }
        if (policies == null) {
            policies = new LinkedHashMap<Object, CachingPolicy>();
            this.contextPolicies.set(policies);
        }
        policies.put(key, new CachingPolicy(policy));
    }

    Policy unregisterPolicy(Object key) {
        Map<Object, CachingPolicy> policies = this.contextPolicies.get();
        if (policies == null || !policies.containsKey(key)) {
            throw new IllegalArgumentException("Policy has not been registered.");
        }
        CachingPolicy cachingPolicy = policies.remove(key);
        if (policies.size() == 0) {
            this.contextPolicies.set(null);
        }
        return cachingPolicy != null ? cachingPolicy.policy : null;
    }

    Policy getPolicy(Object key) {
        Map<Object, CachingPolicy> policies = this.contextPolicies.get();
        if (policies == null) {
            return null;
        }
        CachingPolicy cachingPolicy = policies.get(key);
        return cachingPolicy != null ? cachingPolicy.policy : null;
    }

    public static void setDefaultPolicy(Policy policy) {
        ComposableSecurityManagerPolicy manager = ComposableSecurityManagerPolicy.get();
        if (manager.defaultPolicy != null && policy != null) {
            throw new IllegalArgumentException("Default Policy has already been set.");
        }
        manager.defaultPolicy = policy != null ? Collections.singletonList(new CachingPolicy(policy)) : null;
    }

    public static void registerContextPolicy(Object key, Policy policy) {
        ComposableSecurityManagerPolicy.get().registerPolicy(key, policy);
    }

    public static Policy unregisterContextPolicy(Object key) {
        return ComposableSecurityManagerPolicy.get().unregisterPolicy(key);
    }

    public static Policy getContextPolicy(Object key) {
        return ComposableSecurityManagerPolicy.get().getPolicy(key);
    }

    public static ComposableSecurityManagerPolicy setSystemSecurityManager() {
        SecurityManager originalManager = System.getSecurityManager();
        if (originalManager instanceof ExecCommandPassingSecurityManager) {
            throw new IllegalStateException("System SecurityManager has already been set.");
        }
        ForkJoinPool.commonPool();
        ComposableSecurityManagerPolicy newPolicy = ComposableSecurityManagerPolicy.setPolicy(originalManager);
        System.setSecurityManager(new ExecCommandPassingSecurityManager());
        return newPolicy;
    }

    public static ComposableSecurityManagerPolicy removeSystemSecurityManager() {
        ComposableSecurityManagerPolicy manager = ComposableSecurityManagerPolicy.get();
        try {
            manager.privileged.set(Boolean.TRUE);
            System.setSecurityManager(manager.originalManager);
            java.security.Policy.setPolicy(manager.originalPolicy);
            policy = null;
        }
        finally {
            manager.privileged.set(Boolean.FALSE);
        }
        return manager;
    }
}

