/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer;

import io.takari.builder.enforcer.Policy;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class CachingPolicy {
    final Policy policy;
    private final Set<String> readCache = ConcurrentHashMap.newKeySet();
    private final Set<String> writeCache = ConcurrentHashMap.newKeySet();

    public CachingPolicy(Policy policy) {
        this.policy = policy;
    }

    public void checkSocketPermission() {
        this.policy.checkSocketPermission();
    }

    public void checkPropertyPermission(String action, String name) {
        this.policy.checkPropertyPermission(action, name);
    }

    public void checkExec(String cmd) {
        this.policy.checkExec(cmd);
    }

    public void checkRead(String file) {
        if (this.readCache.add(file)) {
            this.policy.checkRead(file);
        }
    }

    public void checkWrite(String file) {
        if (this.writeCache.add(file)) {
            this.policy.checkWrite(file);
        }
    }
}

