/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer.modularity.maven.internal;

import io.takari.builder.enforcer.ComposableSecurityManagerPolicy;
import io.takari.builder.enforcer.modularity.internal.DefaultProjectBasedirEnforcer;
import io.takari.builder.enforcer.modularity.maven.internal.ModularityEnforcerSessionState;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;

@Named
@SessionScoped
public class MavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private final DefaultProjectBasedirEnforcer enforcer;
    private final ModularityEnforcerSessionState state;

    @Inject
    public MavenLifecycleParticipant(DefaultProjectBasedirEnforcer enforcer, ModularityEnforcerSessionState state) {
        this.enforcer = enforcer;
        this.state = state;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.state.getSessionConfig().logStatus();
        if (this.state.isEnforcerEnabled()) {
            this.enforcer.setupMavenSession(session, this.state.getSessionConfig());
        }
        ComposableSecurityManagerPolicy.setSystemSecurityManager();
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        ComposableSecurityManagerPolicy.removeSystemSecurityManager();
    }
}

