/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer.modularity.internal;

import org.apache.maven.execution.MavenSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionConfig {
    private final Logger log = LoggerFactory.getLogger((String)"SPRINKLING");
    private static final String DISABLED_PROPERTY_NAME = "modularity.enforcer.disabled";
    private static final String LOG_ONLY_PROPERTY_NAME = "modularity.enforcer.logonly";
    static final String ALLOW_BREAKING_PROPERTY_NAME = "modularity.enforcer.allow.breaking.exceptions";
    static final String ALLOW_READ_BY_DEFAULT_PROPERTY_NAME = "modularity.enforcer.allow.read.default";
    static final String ALLOW_WRITE_BY_DEFAULT_PROPERTY_NAME = "modularity.enforcer.allow.write.default";
    private final boolean disabled;
    private final boolean isLogOnly;
    private final boolean isAllowBreakingRules;
    private final boolean isReadByDefault;
    private final boolean isWriteByDefault;

    private boolean readProperty(MavenSession session, String propertyName) {
        String system = session.getSystemProperties().getProperty(propertyName);
        String user = session.getUserProperties().getProperty(propertyName);
        String props = session.getTopLevelProject().getProperties().getProperty(propertyName);
        return Boolean.valueOf(user) != false || Boolean.valueOf(system) != false || Boolean.valueOf(props) != false;
    }

    public SessionConfig(MavenSession session) {
        this.disabled = this.readProperty(session, DISABLED_PROPERTY_NAME);
        this.isLogOnly = this.readProperty(session, LOG_ONLY_PROPERTY_NAME);
        this.isAllowBreakingRules = this.readProperty(session, ALLOW_BREAKING_PROPERTY_NAME);
        this.isReadByDefault = this.isAllowBreakingRules && this.readProperty(session, ALLOW_READ_BY_DEFAULT_PROPERTY_NAME);
        this.isWriteByDefault = this.isAllowBreakingRules && this.readProperty(session, ALLOW_WRITE_BY_DEFAULT_PROPERTY_NAME);
    }

    public void logStatus() {
        if (this.disabled || this.isLogOnly) {
            this.log.warn("Modularity Enforcer is disabled: don't trust this build");
            if (this.isAllowBreakingRules) {
                this.log.info("Modularity Enforcer property modularity.enforcer.allow.breaking.exceptions is true, rules may break modularity: not all modularity errors are displayed");
            }
            if (this.isReadByDefault) {
                this.log.info("Modularity Enforcer property modularity.enforcer.allow.read.default is true, non project files will be readable by default: not all read errors are displayed");
            }
            if (this.isWriteByDefault) {
                this.log.info("Modularity Enforcer property modularity.enforcer.allow.write.default is true, non project files will be writeable by default: not all write errors are displayed");
            }
        } else {
            this.log.info("Modularity Enforcer is enabled");
            if (this.isAllowBreakingRules) {
                this.log.info("Modularity Enforcer property modularity.enforcer.allow.breaking.exceptions is true, rules may break modularity: not all modularity errors are displayed: don't trust this build!!!");
            }
            if (this.isReadByDefault) {
                this.log.info("Modularity Enforcer property modularity.enforcer.allow.read.default is true, non project files will be readable by default: don't trust this build!!!");
            }
            if (this.isWriteByDefault) {
                this.log.info("Modularity Enforcer property modularity.enforcer.allow.write.default is true, non project files will be writeable by default: don't trust this build!!!");
            }
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isLogOnly() {
        return this.isLogOnly;
    }

    public boolean isAllowBreakingRules() {
        return this.isAllowBreakingRules;
    }

    public boolean isReadByDefault() {
        return this.isReadByDefault;
    }

    public boolean isWriteByDefault() {
        return this.isWriteByDefault;
    }
}

