/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer.modularity;

import io.takari.builder.enforcer.internal.EnforcerViolation;
import io.takari.builder.internal.pathmatcher.PathMatcher;
import io.takari.builder.internal.pathmatcher.PathNormalizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class ProjectContext {
    private final String id;
    private final PathNormalizer normalizer;
    private final PathMatcher readMatcher;
    private final PathMatcher writeMatcher;
    private final Set<String> execIncludes;
    private final Set<EnforcerViolation> violations = ConcurrentHashMap.newKeySet();

    public ProjectContext(PathNormalizer normalizer, String id, PathMatcher readMatcher, PathMatcher writeMatcher, Set<String> execIncludes) {
        this.normalizer = normalizer;
        this.id = id;
        this.readMatcher = readMatcher;
        this.writeMatcher = writeMatcher;
        this.execIncludes = execIncludes;
    }

    public final boolean checkRead(String file) {
        return this.readMatcher.includes(this.normalizer.normalize(file));
    }

    public final boolean checkWrite(String file) {
        return this.writeMatcher.includes(this.normalizer.normalize(file));
    }

    public final boolean checkExecute(String exec) {
        return this.execIncludes(exec);
    }

    public void store(OutputStream out) throws IOException {
        class WrappedIOException
        extends RuntimeException {
            public WrappedIOException(IOException cause) {
                super(cause);
            }
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        try {
            try {
                writer.write(this.normalizer.getMemento());
                writer.newLine();
                writer.flush();
            }
            catch (IOException e) {
                throw new WrappedIOException(e);
            }
            class Visitor
            implements PathMatcher.RuleVisitor {
                private final String prefix;
                private final /* synthetic */ BufferedWriter val$writer;

                public Visitor(String prefix, BufferedWriter bufferedWriter) {
                    this.val$writer = bufferedWriter;
                    this.prefix = prefix;
                }

                public void visit(boolean includes, String path) {
                    try {
                        this.val$writer.write(includes ? "+" : "-");
                        this.val$writer.write(this.prefix);
                        this.val$writer.write(path);
                        this.val$writer.newLine();
                    }
                    catch (IOException e) {
                        throw new WrappedIOException(e);
                    }
                }
            }
            this.readMatcher.traverse((PathMatcher.RuleVisitor)new Visitor("R ", writer));
            this.writeMatcher.traverse((PathMatcher.RuleVisitor)new Visitor("W ", writer));
            Visitor execVisitor = new Visitor("E ", writer);
            this.execIncludes.stream().forEach(s -> execVisitor.visit(true, (String)s));
            writer.flush();
        }
        catch (WrappedIOException e) {
            throw (IOException)e.getCause();
        }
    }

    public static ProjectContext load(InputStream is) throws IOException {
        String str;
        HashSet<String> execIncludes = new HashSet<String>();
        BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        PathNormalizer normalizer = PathNormalizer.createNormalizer((String)r.readLine());
        PathMatcher.Builder readMatcherBuilder = PathMatcher.builder((PathNormalizer)normalizer);
        PathMatcher.Builder writeMatcherBuilder = PathMatcher.builder((PathNormalizer)normalizer);
        while ((str = r.readLine()) != null) {
            PathMatcher.Builder builder;
            boolean include = str.startsWith("+");
            if (str.startsWith("+R ") || str.startsWith("-R ")) {
                builder = readMatcherBuilder;
            } else if (str.startsWith("+W ") || str.startsWith("-W ")) {
                builder = writeMatcherBuilder;
            } else if (str.startsWith("+E ")) {
                builder = null;
                execIncludes.add(str.substring(3));
            } else {
                throw new IllegalArgumentException("Invalid path matcher pattern: " + str);
            }
            if (builder == null) continue;
            if ((str = str.substring(3)).endsWith("/")) {
                if (include) {
                    builder.includePrefix(str);
                    continue;
                }
                builder.excludePrefix(str);
                continue;
            }
            if (include) {
                builder.includePath(str);
                continue;
            }
            builder.excludePath(str);
        }
        PathMatcher readMatcher = readMatcherBuilder.build();
        PathMatcher writeMatcher = writeMatcherBuilder.build();
        return new ProjectContext(normalizer, "<unknown>", readMatcher, writeMatcher, execIncludes);
    }

    boolean execIncludes(String execPath) {
        String exec = execPath.contains("/") ? execPath.substring(execPath.lastIndexOf(47) + 1) : execPath;
        return this.execIncludes.stream().anyMatch(pattern -> pattern.equals(exec));
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public synchronized boolean addViolation(EnforcerViolation violation) {
        return this.violations.add(violation);
    }

    public Set<EnforcerViolation> getViolations() {
        return new TreeSet<EnforcerViolation>(this.violations);
    }

    public String matchingRule(char type, String file) {
        switch (type) {
            case 'E': {
                return this.execIncludes(file) ? file : "";
            }
            case 'W': {
                return this.writeMatcher.getMatchingRule(file);
            }
            case 'R': {
                return this.readMatcher.getMatchingRule(file);
            }
        }
        throw new RuntimeException("Don't know about rule type " + type);
    }
}

