/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer.modularity;

import io.takari.builder.enforcer.Policy;
import io.takari.builder.enforcer.internal.EnforcerViolation;
import io.takari.builder.enforcer.internal.EnforcerViolationType;
import io.takari.builder.enforcer.modularity.ProjectContext;
import io.takari.builder.internal.pathmatcher.PathNormalizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;

public class ModularityEnforcementPolicy
implements Policy {
    private final ProjectContext context;
    private final BiConsumer<ProjectContext, EnforcerViolation> handler;
    private final ThreadLocal<Boolean> execPrivileged = new ThreadLocal();
    private final AtomicBoolean inScope = new AtomicBoolean(true);

    public void checkRead(String file) {
        this.checkScope();
        this.checkProjectRead(file);
    }

    public void checkWrite(String file) {
        this.checkScope();
        this.checkProjectWrite(file);
    }

    public void checkExec(String cmd) {
        this.checkScope();
        if (this.execPrivileged.get() != null) {
            return;
        }
        if (!this.context.checkExecute(cmd)) {
            this.handler.accept(this.context, new EnforcerViolation(EnforcerViolationType.EXECUTE, cmd));
        }
    }

    public void checkSocketPermission() {
        this.checkScope();
    }

    public void checkPropertyPermission(String action, String name) {
        this.checkScope();
    }

    public ModularityEnforcementPolicy(ProjectContext context, BiConsumer<ProjectContext, EnforcerViolation> handler) {
        this.context = context;
        this.handler = handler;
    }

    public void checkProjectRead(String file) {
        if (!this.context.checkRead(file)) {
            this.handler.accept(this.context, new EnforcerViolation(EnforcerViolationType.READ, PathNormalizer.normalize0((String)file)));
        }
    }

    public void checkProjectWrite(String file) {
        if (!this.context.checkWrite(file)) {
            this.handler.accept(this.context, new EnforcerViolation(EnforcerViolationType.WRITE, PathNormalizer.normalize0((String)file)));
        }
    }

    public void enterExecPrivileged() {
        this.execPrivileged.set(Boolean.TRUE);
    }

    public void leaveExecPrivileged() {
        this.execPrivileged.remove();
    }

    public ProjectContext getProjectContext() {
        return this.context;
    }

    private void checkScope() {
        if (!this.inScope.get()) {
            throw new IllegalStateException("ModularityEnforcerContext is no longer in scope");
        }
    }

    public void close() {
        this.inScope.set(false);
    }
}

