/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer.internal;

import io.takari.builder.enforcer.internal.EnforcerViolationType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

public class EnforcerViolation
implements Comparable<EnforcerViolation> {
    private final EnforcerViolationType violationType;
    private final String file;
    private final List<String> stackTrace;

    public EnforcerViolation(EnforcerViolationType violationType, String file) {
        this(violationType, file, EnforcerViolation.getStack());
    }

    EnforcerViolation(EnforcerViolationType violationType, String file, List<String> stackTrace) {
        this.violationType = violationType;
        this.file = file;
        this.stackTrace = stackTrace;
    }

    public EnforcerViolationType getViolationType() {
        return this.violationType;
    }

    public String getFile() {
        return this.file;
    }

    public List<String> getStackTrace() {
        return this.stackTrace;
    }

    public String getType() {
        return this.violationType.getType();
    }

    public String getFormattedViolation() {
        return String.valueOf(this.violationType.getType()) + (this.isExec() ? " comand:" : " file:") + this.file;
    }

    private boolean isExec() {
        return EnforcerViolationType.EXECUTE.equals((Object)this.violationType);
    }

    @Override
    public int compareTo(EnforcerViolation o) {
        return this.file.compareTo(o.getFile());
    }

    public String toString() {
        return String.format("%s:%s:%s", new Object[]{this.violationType, this.file, this.stackTrace});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnforcerViolation)) {
            return false;
        }
        EnforcerViolation other = (EnforcerViolation)obj;
        return this.violationType.equals((Object)other.violationType) && this.file.equals(other.file);
    }

    public int hashCode() {
        int result = 31;
        result = result * 17 + this.violationType.hashCode();
        result = result * 17 + this.file.hashCode();
        return result;
    }

    static List<String> getStack() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        ArrayList<String> output = new ArrayList<String>(elements.length);
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            output.add(e.toString());
            ++n2;
        }
        return output;
    }

    public static Writer newWriter(Path outputFile) throws IOException {
        final BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC);
        return new Writer(){

            @Override
            public synchronized void close() throws IOException {
                writer.close();
            }

            @Override
            public synchronized void write(EnforcerViolation violation) {
                try {
                    writer.append(violation.getType()).append(' ').append(violation.getFile()).append('\n');
                    for (String frame : violation.getStackTrace()) {
                        writer.append(' ').append(frame).append('\n');
                    }
                    writer.flush();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    public static List<EnforcerViolation> readFrom(Path outputFile) throws IOException {
        ArrayList<EnforcerViolation> violations = new ArrayList<EnforcerViolation>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = Files.newBufferedReader(outputFile);){
            String str;
            EnforcerViolationType type = null;
            String file = null;
            ArrayList<String> stack = null;
            while ((str = reader.readLine()) != null) {
                if (str.charAt(0) != ' ') {
                    if (type != null && file != null) {
                        violations.add(new EnforcerViolation(type, file, (List<String>)stack));
                    }
                    type = EnforcerViolationType.fromType(str.substring(0, 1));
                    file = str.substring(2);
                    stack = new ArrayList<String>();
                    continue;
                }
                assert (type != null && file != null && stack != null);
                stack.add(str.substring(1));
            }
            if (type != null && file != null) {
                violations.add(new EnforcerViolation(type, file, stack));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return violations;
    }

    public static interface Writer
    extends Closeable {
        public void write(EnforcerViolation var1);
    }
}

