/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.enforcer.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnforcerConfig {
    public static final String ALL_BUILDERS = "*";
    protected static final Logger log = LoggerFactory.getLogger(EnforcerConfig.class);
    protected final Map<String, Collection<String>> readExceptions;
    protected final Map<String, Collection<String>> readAndTrackExceptions;
    protected final Map<String, Collection<String>> writeExceptions;
    protected final Map<String, Collection<String>> execExceptions;
    protected final List<String> exclusions;
    protected final List<String> networkExceptions;
    protected final boolean enforce;

    public static EnforcerConfig fromFile(Path config) {
        Builder builder = new Builder();
        if (config == null) {
            return builder.build();
        }
        boolean enforce = false;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader r = new BufferedReader(new InputStreamReader(Files.newInputStream(config, new OpenOption[0])));){
                String str;
                int lineno = 0;
                while ((str = r.readLine()) != null) {
                    str = str.trim();
                    if (lineno == 0 && "# enforce".equals(str)) {
                        enforce = true;
                        continue;
                    }
                    if (str.startsWith("#") || str.isEmpty()) continue;
                    List parts = Arrays.asList(str.split("\\s+")).stream().map(s -> s.trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
                    if (parts.size() != 3 && parts.size() != 2 && (Type.EXCLUDE.is((String)parts.get(1)) || Type.NETWORK.is((String)parts.get(1)))) {
                        log.warn("Ignored illegal configuration line #{} : wrong number of parts", (Object)lineno);
                        continue;
                    }
                    String identifier = (String)parts.get(0);
                    String action = (String)parts.get(1);
                    String path = parts.size() == 2 ? null : (String)parts.get(2);
                    Type type = Type.get(action);
                    if (type == null) {
                        log.warn("Ignored illegal configuration line #{} : wrong action {}", (Object)lineno, (Object)action);
                        continue;
                    }
                    switch (type) {
                        case READ: {
                            builder.withReadException(identifier, path);
                            break;
                        }
                        case READ_AND_TRACK: {
                            builder.withReadAndTrackException(identifier, path);
                            break;
                        }
                        case WRITE: {
                            builder.withWriteException(identifier, path);
                            break;
                        }
                        case EXECUTE: {
                            builder.withExecException(identifier, path);
                            break;
                        }
                        case EXCLUDE: {
                            builder.withExclusion(identifier);
                            break;
                        }
                        case NETWORK: {
                            builder.withNetworkException(identifier);
                        }
                    }
                    ++lineno;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            log.error("Could not read enforcer config file {}", (Object)config, (Object)e);
        }
        builder.enforce(enforce);
        return builder.build();
    }

    private EnforcerConfig(boolean enforce, Map<String, Collection<String>> readExceptions, Map<String, Collection<String>> readAndTrackExceptions, Map<String, Collection<String>> writeExceptions, Map<String, Collection<String>> execExceptions, List<String> exclusions, List<String> networkExceptions) {
        this.enforce = enforce;
        this.readExceptions = Collections.unmodifiableMap(readExceptions);
        this.readAndTrackExceptions = Collections.unmodifiableMap(readAndTrackExceptions);
        this.writeExceptions = Collections.unmodifiableMap(writeExceptions);
        this.execExceptions = Collections.unmodifiableMap(execExceptions);
        this.exclusions = Collections.unmodifiableList(exclusions);
        this.networkExceptions = Collections.unmodifiableList(networkExceptions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static EnforcerConfig empty() {
        return new Builder().enforce(true).build();
    }

    public Collection<String> getReadExceptions(String identifier) {
        return EnforcerConfig.getExceptions(identifier, this.readExceptions);
    }

    public Collection<String> getReadAndTrackExceptions(String identifier) {
        return EnforcerConfig.getExceptions(identifier, this.readAndTrackExceptions);
    }

    public Collection<String> getWriteExceptions(String identifier) {
        return EnforcerConfig.getExceptions(identifier, this.writeExceptions);
    }

    public Collection<String> getExecExceptions(String identifier) {
        return EnforcerConfig.getExceptions(identifier, this.execExceptions);
    }

    private static Collection<String> getExceptions(String identifier, Map<String, Collection<String>> exceptionMap) {
        Collection<String> exceptions = ALL_BUILDERS.equals(identifier) ? exceptionMap.get(ALL_BUILDERS) : EnforcerConfig.concat(exceptionMap.get(ALL_BUILDERS), exceptionMap.get(identifier));
        return exceptions == null ? Collections.emptyList() : Collections.unmodifiableCollection(exceptions);
    }

    public boolean enforce() {
        return this.enforce;
    }

    public boolean exclude(String identifier) {
        return this.exclusions.contains(identifier);
    }

    public boolean allowNetworkAccess(String identifier) {
        return this.networkExceptions.contains(identifier);
    }

    private static <T> Collection<T> concat(Collection<? extends T> a, Collection<? extends T> b) {
        return Stream.concat(a != null ? a.stream() : Stream.empty(), b != null ? b.stream() : Stream.empty()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean hasEntriesFor(String identifier) {
        if (Stream.of(this.readExceptions, this.readAndTrackExceptions, this.writeExceptions, this.execExceptions).anyMatch(m -> m.containsKey(identifier))) {
            return true;
        }
        return Stream.of(this.exclusions, this.networkExceptions).anyMatch(l -> l.contains(identifier));
    }

    public boolean hasWildcardEntries() {
        return Stream.of(this.readExceptions, this.readAndTrackExceptions, this.writeExceptions, this.execExceptions).anyMatch(m -> m.containsKey(ALL_BUILDERS));
    }

    /* synthetic */ EnforcerConfig(boolean bl, Map map, Map map2, Map map3, Map map4, List list, List list2, EnforcerConfig enforcerConfig) {
        this(bl, map, map2, map3, map4, list, list2);
    }

    public static class Builder {
        final Map<String, Collection<String>> readExceptions = new LinkedHashMap<String, Collection<String>>();
        final Map<String, Collection<String>> readAndTrackExceptions = new LinkedHashMap<String, Collection<String>>();
        final Map<String, Collection<String>> writeExceptions = new LinkedHashMap<String, Collection<String>>();
        final Map<String, Collection<String>> execExceptions = new LinkedHashMap<String, Collection<String>>();
        final List<String> exclusions = new ArrayList<String>();
        final List<String> networkExceptions = new ArrayList<String>();
        protected boolean enforce;

        private Builder() {
        }

        public Builder enforce(boolean enforce) {
            this.enforce = enforce;
            return this;
        }

        public Builder withReadException(String identifier, String path) {
            this.putToMultimap(this.readExceptions, identifier, path);
            return this;
        }

        public Builder withReadAndTrackException(String identifier, String path) {
            this.putToMultimap(this.readAndTrackExceptions, identifier, path);
            return this;
        }

        public Builder withWriteException(String identifier, String path) {
            this.putToMultimap(this.writeExceptions, identifier, path);
            return this;
        }

        public Builder withExecException(String identifier, String command) {
            this.putToMultimap(this.execExceptions, identifier, command);
            return this;
        }

        public Builder withExclusion(String exclusion) {
            this.exclusions.add(exclusion);
            return this;
        }

        public Builder withNetworkException(String networkException) {
            this.networkExceptions.add(networkException);
            return this;
        }

        public EnforcerConfig build() {
            return new EnforcerConfig(this.enforce, this.readExceptions, this.readAndTrackExceptions, this.writeExceptions, this.execExceptions, this.exclusions, this.networkExceptions, null);
        }

        private void putToMultimap(Map<String, Collection<String>> multimap, String key, String value) {
            Collection<String> c = multimap.get(key);
            if (c == null) {
                c = new LinkedHashSet<String>();
                multimap.put(key, c);
            }
            c.add(value);
        }
    }

    protected static enum Type {
        EXCLUDE("P"),
        NETWORK("N"),
        EXECUTE("E"),
        READ("R"),
        READ_AND_TRACK("RT"),
        WRITE("W");

        private final String key;

        private Type(String key) {
            this.key = key;
        }

        private boolean is(String key) {
            return this.key.equals(key);
        }

        private static Type get(String key) {
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type t = typeArray[n2];
                if (t.key.equals(key)) {
                    return t;
                }
                ++n2;
            }
            return null;
        }
    }
}

