/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.parameters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.models.parameters.AbstractParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"name", "in", "description", "required", "type", "items", "collectionFormat", "default", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxItems", "minItems"})
public abstract class AbstractSerializableParameter<T extends AbstractSerializableParameter<T>>
extends AbstractParameter
implements SerializableParameter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSerializableParameter.class);
    protected String type;
    protected String format;
    protected String collectionFormat;
    protected Property items;
    protected List<String> _enum;
    protected Boolean exclusiveMaximum;
    protected Double maximum;
    protected Boolean exclusiveMinimum;
    protected Double minimum;
    protected String example;
    private Integer maxItems;
    private Integer minItems;
    @JsonIgnore
    protected String defaultValue;

    public T property(Property property) {
        this.setProperty(property);
        return this.castThis();
    }

    public T type(String type) {
        this.setType(type);
        return this.castThis();
    }

    public T format(String format) {
        this.setFormat(format);
        return this.castThis();
    }

    public T description(String description) {
        this.setDescription(description);
        return this.castThis();
    }

    public T name(String name) {
        this.setName(name);
        return this.castThis();
    }

    public T required(boolean required) {
        this.setRequired(required);
        return this.castThis();
    }

    public T collectionFormat(String collectionFormat) {
        this.setCollectionFormat(collectionFormat);
        return this.castThis();
    }

    public T example(String example) {
        this.setExample(example);
        return this.castThis();
    }

    @JsonIgnore
    protected String getDefaultCollectionFormat() {
        return "csv";
    }

    public T items(Property items) {
        this.items = items;
        return this.castThis();
    }

    public T _enum(List<String> value) {
        this._enum = value;
        return this.castThis();
    }

    @Override
    public List<String> getEnum() {
        return this._enum;
    }

    @Override
    public void setEnum(List<String> _enum) {
        this._enum = _enum;
    }

    @Override
    public Property getItems() {
        return this.items;
    }

    @Override
    public void setItems(Property items) {
        this.items = items;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
        this.setCollectionFormat(ArrayProperty.isType(type) ? this.getDefaultCollectionFormat() : null);
    }

    @Override
    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    @Override
    public void setCollectionFormat(String collectionFormat) {
        this.collectionFormat = collectionFormat;
    }

    public void setProperty(Property property) {
        this.setType(property.getType());
        this.format = property.getFormat();
        if (property instanceof StringProperty) {
            StringProperty string = (StringProperty)property;
            this.setEnum(string.getEnum());
        } else if (property instanceof ArrayProperty) {
            ArrayProperty array = (ArrayProperty)property;
            this.setItems(array.getItems());
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getDefault() {
        if (this.defaultValue == null) {
            return null;
        }
        try {
            if ("integer".equals(this.type)) {
                return Long.valueOf(this.defaultValue);
            }
            if ("number".equals(this.type)) {
                return Double.valueOf(this.defaultValue);
            }
            if ("boolean".equals(this.type) && ("true".equalsIgnoreCase(this.defaultValue) || "false".equalsIgnoreCase(this.defaultValue))) {
                return Boolean.valueOf(this.defaultValue);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn(String.format("Illegal DefaultValue %s for parameter type %s", this.defaultValue, this.type), (Throwable)e);
        }
        return this.defaultValue;
    }

    public void setDefault(Object defaultValue) {
        this.defaultValue = defaultValue == null ? null : defaultValue.toString();
    }

    public Boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public void setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }

    public Boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public void setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public void setMinItems(Integer minItems) {
        this.minItems = minItems;
    }

    @JsonProperty(value="x-example")
    public Object getExample() {
        if (this.example == null) {
            return null;
        }
        try {
            if ("integer".equals(this.type)) {
                return Long.valueOf(this.example);
            }
            if ("number".equals(this.type)) {
                return Double.valueOf(this.example);
            }
            if ("boolean".equals(this.type) && ("true".equalsIgnoreCase(this.example) || "false".equalsIgnoreCase(this.defaultValue))) {
                return Boolean.valueOf(this.example);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn(String.format("Illegal DefaultValue %s for parameter type %s", this.defaultValue, this.type), (Throwable)e);
        }
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    @JsonIgnore
    private T castThis() {
        AbstractSerializableParameter result = this;
        return (T)result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractSerializableParameter)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractSerializableParameter that = (AbstractSerializableParameter)o;
        if (this.getType() != null ? !this.getType().equals(that.getType()) : that.getType() != null) {
            return false;
        }
        if (this.getFormat() != null ? !this.getFormat().equals(that.getFormat()) : that.getFormat() != null) {
            return false;
        }
        if (this.getCollectionFormat() != null ? !this.getCollectionFormat().equals(that.getCollectionFormat()) : that.getCollectionFormat() != null) {
            return false;
        }
        if (this.getItems() != null ? !this.getItems().equals(that.getItems()) : that.getItems() != null) {
            return false;
        }
        if (this._enum != null ? !this._enum.equals(that._enum) : that._enum != null) {
            return false;
        }
        if (this.exclusiveMaximum != null ? !this.exclusiveMaximum.equals(that.exclusiveMaximum) : that.exclusiveMaximum != null) {
            return false;
        }
        if (this.getMaximum() != null ? !this.getMaximum().equals(that.getMaximum()) : that.getMaximum() != null) {
            return false;
        }
        if (this.exclusiveMinimum != null ? !this.exclusiveMinimum.equals(that.exclusiveMinimum) : that.exclusiveMinimum != null) {
            return false;
        }
        if (this.getMinimum() != null ? !this.getMinimum().equals(that.getMinimum()) : that.getMinimum() != null) {
            return false;
        }
        if (this.getExample() != null ? !this.getExample().equals(that.getExample()) : that.getExample() != null) {
            return false;
        }
        if (this.getMaxItems() != null ? !this.getMaxItems().equals(that.getMaxItems()) : that.getMaxItems() != null) {
            return false;
        }
        if (this.getMinItems() != null ? !this.getMinItems().equals(that.getMinItems()) : that.getMinItems() != null) {
            return false;
        }
        return !(this.getDefaultValue() == null ? that.getDefaultValue() != null : !this.getDefaultValue().equals(that.getDefaultValue()));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        result = 31 * result + (this.getFormat() != null ? this.getFormat().hashCode() : 0);
        result = 31 * result + (this.getCollectionFormat() != null ? this.getCollectionFormat().hashCode() : 0);
        result = 31 * result + (this.getItems() != null ? this.getItems().hashCode() : 0);
        result = 31 * result + (this._enum != null ? this._enum.hashCode() : 0);
        result = 31 * result + (this.exclusiveMaximum != null ? this.exclusiveMaximum.hashCode() : 0);
        result = 31 * result + (this.getMaximum() != null ? this.getMaximum().hashCode() : 0);
        result = 31 * result + (this.exclusiveMinimum != null ? this.exclusiveMinimum.hashCode() : 0);
        result = 31 * result + (this.getMinimum() != null ? this.getMinimum().hashCode() : 0);
        result = 31 * result + (this.getExample() != null ? this.getExample().hashCode() : 0);
        result = 31 * result + (this.getMaxItems() != null ? this.getMaxItems().hashCode() : 0);
        result = 31 * result + (this.getMinItems() != null ? this.getMinItems().hashCode() : 0);
        result = 31 * result + (this.getDefaultValue() != null ? this.getDefaultValue().hashCode() : 0);
        return result;
    }
}

