/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NodeJSServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String apiVersion = "1.0.0";
    protected int serverPort = 8080;
    protected String projectName = "swagger-server";

    public NodeJSServerCodegen() {
        this.outputFolder = "generated-code/nodejs";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.put("controller.mustache", ".js");
        this.templateDir = "nodejs";
        this.embeddedTemplateDir = "nodejs";
        this.reservedWords = new HashSet<String>(Arrays.asList("break", "case", "class", "catch", "const", "continue", "debugger", "default", "delete", "do", "else", "export", "extends", "finally", "for", "function", "if", "import", "in", "instanceof", "let", "new", "return", "super", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "yield"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("serverPort", this.serverPort);
        this.supportingFiles.add(new SupportingFile("swagger.mustache", "api", "swagger.yaml"));
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.js"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        if (System.getProperty("noservice") == null) {
            this.apiTemplateFiles.put("service.mustache", "Service.js");
        }
    }

    @Override
    public String apiPackage() {
        return "controllers";
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "nodejs";
    }

    @Override
    public String getHelp() {
        return "Generates a nodejs server library using the swagger-tools project.  By default, it will also generate service classes--which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultController";
        }
        return this.initialCaps(name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation operation : operations) {
            List<CodegenResponse> responses;
            operation.httpMethod = operation.httpMethod.toLowerCase();
            List<CodegenParameter> params = operation.allParams;
            if (params != null && params.size() == 0) {
                operation.allParams = null;
            }
            if ((responses = operation.responses) != null) {
                for (CodegenResponse resp : responses) {
                    if (!"0".equals(resp.code)) continue;
                    resp.code = "default";
                }
            }
            if (operation.examples == null || operation.examples.isEmpty()) continue;
            Iterator<Map<String, String>> it = operation.examples.iterator();
            while (it.hasNext()) {
                Map<String, String> example = it.next();
                String contentType = example.get("contentType");
                if (contentType != null && contentType.startsWith("application/json")) continue;
                it.remove();
            }
        }
        return objs;
    }

    private List<Map<String, Object>> getOperations(Map<String, Object> objs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map apiInfo = (Map)objs.get("apiInfo");
        List apis = (List)apiInfo.get("apis");
        for (Map api : apis) {
            result.add((Map)api.get("operations"));
        }
        return result;
    }

    private List<Map<String, Object>> sortOperationsByPath(List<CodegenOperation> ops) {
        ArrayListMultimap opsByPath = ArrayListMultimap.create();
        for (CodegenOperation op : ops) {
            opsByPath.put((Object)op.path, (Object)op);
        }
        ArrayList<Map<String, Object>> opsByPathList = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : opsByPath.asMap().entrySet()) {
            HashMap<String, Object> opsByPathEntry = new HashMap<String, Object>();
            opsByPathList.add(opsByPathEntry);
            opsByPathEntry.put("path", entry.getKey());
            opsByPathEntry.put("operation", entry.getValue());
            ArrayList operationsForThisPath = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            ((CodegenOperation)operationsForThisPath.get((int)(operationsForThisPath.size() - 1))).hasMore = null;
            if (opsByPathList.size() >= opsByPath.asMap().size()) continue;
            opsByPathEntry.put("hasMore", "true");
        }
        return opsByPathList;
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        String[] parts;
        if ("/".equals(swagger.getBasePath())) {
            swagger.setBasePath("");
        }
        String host = swagger.getHost();
        String port = "8080";
        if (host != null && (parts = host.split(":")).length > 1) {
            port = parts[1];
        }
        this.additionalProperties.put("serverPort", port);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Swagger swagger = (Swagger)objs.get("swagger");
        if (swagger != null) {
            try {
                SimpleModule module = new SimpleModule();
                module.addSerializer(Double.class, (JsonSerializer)new JsonSerializer<Double>(){

                    public void serialize(Double val, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                        jgen.writeNumber(new BigDecimal(val));
                    }
                });
                objs.put("swagger-yaml", Yaml.mapper().registerModule((Module)module).writeValueAsString((Object)swagger));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        for (Map<String, Object> operations : this.getOperations(objs)) {
            List ops = (List)operations.get("operation");
            List<Map<String, Object>> opsByPathList = this.sortOperationsByPath(ops);
            operations.put("operationsByPath", opsByPathList);
        }
        return super.postProcessSupportingFileData(objs);
    }
}

