/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.AbstractGenerator;
import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.SupportingFile;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;

@Deprecated
public class MetaGenerator
extends AbstractGenerator {
    static Map<String, CodegenConfig> configs = new HashMap<String, CodegenConfig>();
    static String configString;

    public static void main(String[] args) {
        new MetaGenerator().generate(args);
    }

    public static List<CodegenConfig> getExtensions() {
        ServiceLoader<CodegenConfig> loader = ServiceLoader.load(CodegenConfig.class);
        ArrayList<CodegenConfig> output = new ArrayList<CodegenConfig>();
        Iterator<CodegenConfig> itr = loader.iterator();
        while (itr.hasNext()) {
            output.add(itr.next());
        }
        return output;
    }

    static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("MetaGenerator. Generator for creating a new template set and configuration for Codegen.  The output will be based on the language you specify, and includes default templates to include.", options);
    }

    public static CodegenConfig getConfig(String name) {
        if (configs.containsKey(name)) {
            return configs.get(name);
        }
        return null;
    }

    protected void generate(String[] args) {
        File resourcesFolder;
        File sourceFolder;
        StringBuilder sb = new StringBuilder();
        String targetLanguage = null;
        String outputFolder = null;
        String name = null;
        String targetPackage = "io.swagger.codegen";
        String templateDir = "codegen";
        Options options = new Options();
        options.addOption("h", "help", false, "shows this message");
        options.addOption("l", "lang", false, "client language to generate.\nAvailable languages include:\n\t[" + configString + "]");
        options.addOption("o", "output", true, "where to write the generated files");
        options.addOption("n", "name", true, "the human-readable name of the generator");
        options.addOption("p", "package", true, "the package to put the main class into (defaults to io.swagger.codegen");
        ClientOptInput clientOptInput = new ClientOptInput();
        Object swagger = null;
        CommandLine cmd = null;
        try {
            BasicParser parser = new BasicParser();
            cmd = parser.parse(options, args);
            if (cmd.hasOption("h")) {
                MetaGenerator.usage(options);
                return;
            }
            if (!cmd.hasOption("n")) {
                System.out.println("name is required");
                MetaGenerator.usage(options);
                return;
            }
            name = cmd.getOptionValue("n");
            if (cmd.hasOption("l")) {
                targetLanguage = cmd.getOptionValue("l");
            }
            if (cmd.hasOption("p")) {
                targetPackage = cmd.getOptionValue("p");
            }
            if (!cmd.hasOption("o")) {
                System.out.println("output folder is required");
                MetaGenerator.usage(options);
                return;
            }
            outputFolder = cmd.getOptionValue("o");
        }
        catch (Exception e) {
            MetaGenerator.usage(options);
            return;
        }
        System.out.println("writing to folder " + outputFolder);
        File outputFolderLocation = new File(outputFolder);
        if (!outputFolderLocation.exists()) {
            outputFolderLocation.mkdirs();
        }
        if (!(sourceFolder = new File(outputFolder + File.separator + "src/main/java/" + targetPackage.replace('.', File.separatorChar))).exists()) {
            sourceFolder.mkdirs();
        }
        if (!(resourcesFolder = new File(outputFolder + File.separator + "src/main/resources/META-INF/services")).exists()) {
            resourcesFolder.mkdirs();
        }
        String mainClass = Character.toUpperCase(name.charAt(0)) + name.substring(1) + "Generator";
        ArrayList<SupportingFile> supportingFiles = new ArrayList<SupportingFile>();
        supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        supportingFiles.add(new SupportingFile("generatorClass.mustache", "src/main/java/" + File.separator + targetPackage.replace('.', File.separatorChar), mainClass + ".java"));
        supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        supportingFiles.add(new SupportingFile("api.template", "src/main/resources" + File.separator + name, "api.mustache"));
        supportingFiles.add(new SupportingFile("model.template", "src/main/resources" + File.separator + name, "model.mustache"));
        supportingFiles.add(new SupportingFile("services.mustache", "src/main/resources/META-INF/services", "io.swagger.codegen.CodegenConfig"));
        ArrayList<File> files = new ArrayList<File>();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("generatorPackage", targetPackage);
        data.put("generatorClass", mainClass);
        data.put("name", name);
        data.put("fullyQualifiedGeneratorClass", targetPackage + "." + mainClass);
        for (SupportingFile support : supportingFiles) {
            try {
                String template;
                File of;
                String destinationFolder = outputFolder;
                if (support.folder != null && !"".equals(support.folder)) {
                    destinationFolder = destinationFolder + File.separator + support.folder;
                }
                if (!(of = new File(destinationFolder)).isDirectory()) {
                    of.mkdirs();
                }
                String outputFilename = destinationFolder + File.separator + support.destinationFilename;
                if (support.templateFile.endsWith("mustache")) {
                    template = this.readTemplate("codegen" + File.separator + support.templateFile);
                    Template tmpl = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                        public Reader getTemplate(String name) {
                            return MetaGenerator.this.getTemplateReader("codegen" + File.separator + name + ".mustache");
                        }
                    }).defaultValue("").compile(template);
                    this.writeToFile(outputFilename, tmpl.execute(data));
                    files.add(new File(outputFilename));
                    continue;
                }
                template = this.readTemplate("codegen" + File.separator + support.templateFile);
                FileUtils.writeStringToFile((File)new File(outputFilename), (String)template);
                System.out.println("copying file to " + outputFilename);
                files.add(new File(outputFilename));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        List<CodegenConfig> extensions = MetaGenerator.getExtensions();
        StringBuilder sb = new StringBuilder();
        for (CodegenConfig config : extensions) {
            if (sb.toString().length() != 0) {
                sb.append(", ");
            }
            sb.append(config.getName());
            configs.put(config.getName(), config);
            configString = sb.toString();
        }
    }
}

