/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import springfox.documentation.spi.service.contexts.DocumentationContext;

public class ExpansionContext {
    private final String parentName;
    private final ResolvedType paramType;
    private final DocumentationContext documentationContext;
    private final Set<ResolvedType> seenTypes;

    public ExpansionContext(String parentName, ResolvedType paramType, DocumentationContext documentationContext) {
        this(parentName, paramType, documentationContext, Sets.newHashSet());
    }

    private ExpansionContext(String parentName, ResolvedType paramType, DocumentationContext documentationContext, Set<ResolvedType> seenTypes) {
        this.parentName = parentName;
        this.paramType = paramType;
        this.documentationContext = documentationContext;
        this.seenTypes = Sets.newHashSet(seenTypes);
    }

    public String getParentName() {
        return this.parentName;
    }

    public ResolvedType getParamType() {
        return this.paramType;
    }

    public DocumentationContext getDocumentationContext() {
        return this.documentationContext;
    }

    public boolean hasSeenType(ResolvedType type) {
        return this.seenTypes.contains(type) || Objects.equal((Object)type, (Object)this.paramType);
    }

    public ExpansionContext childContext(String parentName, ResolvedType childType, DocumentationContext documentationContext) {
        HashSet childSeenTypes = Sets.newHashSet(this.seenTypes);
        childSeenTypes.add(childType);
        return new ExpansionContext(parentName, childType, documentationContext, childSeenTypes);
    }
}

