/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.trace.event.naming.HealthStateChangeTraceEvent;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.healthcheck.RsInfo;
import com.alibaba.nacos.naming.healthcheck.heartbeat.BeatProcessor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.push.UdpPushService;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;

public class ClientBeatProcessor
implements BeatProcessor {
    private RsInfo rsInfo;
    private Service service;

    @JsonIgnore
    public UdpPushService getPushService() {
        return (UdpPushService)ApplicationUtils.getBean(UdpPushService.class);
    }

    public RsInfo getRsInfo() {
        return this.rsInfo;
    }

    public void setRsInfo(RsInfo rsInfo) {
        this.rsInfo = rsInfo;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    @Override
    public void run() {
        Service service = this.service;
        if (Loggers.EVT_LOG.isDebugEnabled()) {
            Loggers.EVT_LOG.debug("[CLIENT-BEAT] processing beat: {}", (Object)this.rsInfo.toString());
        }
        String ip = this.rsInfo.getIp();
        String clusterName = this.rsInfo.getCluster();
        int port = this.rsInfo.getPort();
        Cluster cluster = service.getClusterMap().get(clusterName);
        List<Instance> instances = cluster.allIPs(true);
        for (Instance instance : instances) {
            if (!instance.getIp().equals(ip) || instance.getPort() != port) continue;
            if (Loggers.EVT_LOG.isDebugEnabled()) {
                Loggers.EVT_LOG.debug("[CLIENT-BEAT] refresh beat: {}", (Object)this.rsInfo.toString());
            }
            instance.setLastBeat(System.currentTimeMillis());
            if (instance.isMarked() || instance.isHealthy()) continue;
            instance.setHealthy(true);
            Loggers.EVT_LOG.info("service: {} {POS} {IP-ENABLED} valid: {}:{}@{}, region: {}, msg: client beat ok", new Object[]{cluster.getService().getName(), ip, port, cluster.getName(), "unknown"});
            this.getPushService().serviceChanged(service);
            NotifyCenter.publishEvent((Event)new HealthStateChangeTraceEvent(System.currentTimeMillis(), service.getNamespaceId(), service.getGroupName(), service.getName(), instance.getIp(), instance.getPort(), true, "client_beat"));
        }
    }
}

