/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.stereotype.Component;

@Component
public class UpgradeStates
extends Subscriber<UpgradeStateChangedEvent> {
    private static final String FILE_NAME = "upgrade.state";
    private static final String UPGRADED_KEY = "upgraded";
    public static final Path UPGRADE_STATE_FILE = Paths.get(EnvUtil.getNacosHome() + File.separator + "data" + File.separator + "upgrade.state", new String[0]);
    private final Properties properties = new Properties();

    @PostConstruct
    private void init() throws IOException {
        if (Files.isDirectory(UPGRADE_STATE_FILE, new LinkOption[0])) {
            throw new IOException(UPGRADE_STATE_FILE + " is a directory");
        }
        try {
            Files.createDirectories(UPGRADE_STATE_FILE.getParent().toAbsolutePath(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        this.readFromDisk();
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    @PreDestroy
    private void destroy() throws IOException {
        this.writeToDisk();
    }

    private void readFromDisk() {
        block9: {
            try {
                if (Files.notExists(UPGRADE_STATE_FILE, new LinkOption[0])) {
                    Loggers.SRV_LOG.info("{} file is not exist", (Object)FILE_NAME);
                    return;
                }
                if (!Files.isRegularFile(UPGRADE_STATE_FILE, new LinkOption[0])) break block9;
                try (InputStream is = Files.newInputStream(UPGRADE_STATE_FILE, new OpenOption[0]);){
                    this.properties.load(is);
                }
            }
            catch (Exception e) {
                Loggers.SRV_LOG.error("Failed to load file " + UPGRADE_STATE_FILE, (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }

    private void writeToDisk() throws IOException {
        try (OutputStream os = Files.newOutputStream(UPGRADE_STATE_FILE, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            this.properties.store(os, null);
        }
    }

    public Boolean isUpgraded() {
        String value = this.properties.getProperty(UPGRADED_KEY);
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    public void onEvent(UpgradeStateChangedEvent event) {
        this.properties.setProperty(UPGRADED_KEY, String.valueOf(event.isUpgraded));
        try {
            this.writeToDisk();
        }
        catch (IOException e) {
            Loggers.EVT_LOG.error("Failed to write upgrade.state to disk", (Throwable)e);
        }
    }

    public Class<? extends Event> subscribeType() {
        return UpgradeStateChangedEvent.class;
    }

    public static class UpgradeStateChangedEvent
    extends Event {
        private final boolean isUpgraded;

        public UpgradeStateChangedEvent(boolean isUpgraded) {
            this.isUpgraded = isUpgraded;
        }

        public boolean isUpgraded() {
            return this.isUpgraded;
        }
    }
}

