/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.client;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.ClientSyncData;
import com.alibaba.nacos.naming.core.v2.event.client.ClientEvent;
import com.alibaba.nacos.naming.core.v2.pojo.BatchInstanceData;
import com.alibaba.nacos.naming.core.v2.pojo.BatchInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.alibaba.nacos.naming.pojo.Subscriber;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractClient
implements Client {
    protected final ConcurrentHashMap<Service, InstancePublishInfo> publishers = new ConcurrentHashMap(16, 0.75f, 1);
    protected final ConcurrentHashMap<Service, Subscriber> subscribers = new ConcurrentHashMap(16, 0.75f, 1);
    protected volatile long lastUpdatedTime = System.currentTimeMillis();

    @Override
    public void setLastUpdatedTime() {
        this.lastUpdatedTime = System.currentTimeMillis();
    }

    @Override
    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Override
    public boolean addServiceInstance(Service service, InstancePublishInfo instancePublishInfo) {
        if (null == this.publishers.put(service, instancePublishInfo)) {
            if (instancePublishInfo instanceof BatchInstancePublishInfo) {
                MetricsMonitor.incrementIpCountWithBatchRegister(instancePublishInfo);
            } else {
                MetricsMonitor.incrementInstanceCount();
            }
        }
        NotifyCenter.publishEvent((Event)new ClientEvent.ClientChangedEvent(this));
        Loggers.SRV_LOG.info("Client change for service {}, {}", (Object)service, (Object)this.getClientId());
        return true;
    }

    @Override
    public InstancePublishInfo removeServiceInstance(Service service) {
        InstancePublishInfo result = this.publishers.remove(service);
        if (null != result) {
            if (result instanceof BatchInstancePublishInfo) {
                MetricsMonitor.decrementIpCountWithBatchRegister(result);
            } else {
                MetricsMonitor.decrementInstanceCount();
            }
            NotifyCenter.publishEvent((Event)new ClientEvent.ClientChangedEvent(this));
        }
        Loggers.SRV_LOG.info("Client remove for service {}, {}", (Object)service, (Object)this.getClientId());
        return result;
    }

    @Override
    public InstancePublishInfo getInstancePublishInfo(Service service) {
        return this.publishers.get(service);
    }

    @Override
    public Collection<Service> getAllPublishedService() {
        return this.publishers.keySet();
    }

    @Override
    public boolean addServiceSubscriber(Service service, Subscriber subscriber) {
        if (null == this.subscribers.put(service, subscriber)) {
            MetricsMonitor.incrementSubscribeCount();
        }
        return true;
    }

    @Override
    public boolean removeServiceSubscriber(Service service) {
        if (null != this.subscribers.remove(service)) {
            MetricsMonitor.decrementSubscribeCount();
        }
        return true;
    }

    @Override
    public Subscriber getSubscriber(Service service) {
        return this.subscribers.get(service);
    }

    @Override
    public Collection<Service> getAllSubscribeService() {
        return this.subscribers.keySet();
    }

    @Override
    public ClientSyncData generateSyncData() {
        LinkedList<String> namespaces = new LinkedList<String>();
        LinkedList<String> groupNames = new LinkedList<String>();
        LinkedList<String> serviceNames = new LinkedList<String>();
        LinkedList<String> batchNamespaces = new LinkedList<String>();
        LinkedList<String> batchGroupNames = new LinkedList<String>();
        LinkedList<String> batchServiceNames = new LinkedList<String>();
        LinkedList<InstancePublishInfo> instances = new LinkedList<InstancePublishInfo>();
        LinkedList<BatchInstancePublishInfo> batchInstancePublishInfos = new LinkedList<BatchInstancePublishInfo>();
        BatchInstanceData batchInstanceData = new BatchInstanceData();
        for (Map.Entry<Service, InstancePublishInfo> entry : this.publishers.entrySet()) {
            InstancePublishInfo instancePublishInfo = entry.getValue();
            if (instancePublishInfo instanceof BatchInstancePublishInfo) {
                BatchInstancePublishInfo batchInstance = (BatchInstancePublishInfo)instancePublishInfo;
                batchInstancePublishInfos.add(batchInstance);
                AbstractClient.buildBatchInstanceData(batchInstanceData, batchNamespaces, batchGroupNames, batchServiceNames, entry);
                batchInstanceData.setBatchInstancePublishInfos(batchInstancePublishInfos);
                continue;
            }
            namespaces.add(entry.getKey().getNamespace());
            groupNames.add(entry.getKey().getGroup());
            serviceNames.add(entry.getKey().getName());
            instances.add(entry.getValue());
        }
        return new ClientSyncData(this.getClientId(), namespaces, groupNames, serviceNames, instances, batchInstanceData);
    }

    private static BatchInstanceData buildBatchInstanceData(BatchInstanceData batchInstanceData, List<String> batchNamespaces, List<String> batchGroupNames, List<String> batchServiceNames, Map.Entry<Service, InstancePublishInfo> entry) {
        batchNamespaces.add(entry.getKey().getNamespace());
        batchGroupNames.add(entry.getKey().getGroup());
        batchServiceNames.add(entry.getKey().getName());
        batchInstanceData.setNamespaces(batchNamespaces);
        batchInstanceData.setGroupNames(batchGroupNames);
        batchInstanceData.setServiceNames(batchServiceNames);
        return batchInstanceData;
    }

    @Override
    public void release() {
        Collection<InstancePublishInfo> instancePublishInfos = this.publishers.values();
        for (InstancePublishInfo instancePublishInfo : instancePublishInfos) {
            if (instancePublishInfo instanceof BatchInstancePublishInfo) {
                MetricsMonitor.decrementIpCountWithBatchRegister(instancePublishInfo);
                continue;
            }
            MetricsMonitor.getIpCountMonitor().addAndGet(-1 * this.publishers.size());
        }
        MetricsMonitor.getIpCountMonitor().addAndGet(-1 * this.subscribers.size());
    }
}

