/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2;

import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceManager {
    private static final ServiceManager INSTANCE = new ServiceManager();
    private final ConcurrentHashMap<Service, Service> singletonRepository = new ConcurrentHashMap(1024);
    private final ConcurrentHashMap<String, Set<Service>> namespaceSingletonMaps = new ConcurrentHashMap(4);

    private ServiceManager() {
    }

    public static ServiceManager getInstance() {
        return INSTANCE;
    }

    public Set<Service> getSingletons(String namespace) {
        return this.namespaceSingletonMaps.getOrDefault(namespace, new HashSet(1));
    }

    public Service getSingleton(Service service) {
        this.singletonRepository.putIfAbsent(service, service);
        Service result = this.singletonRepository.get(service);
        this.namespaceSingletonMaps.computeIfAbsent(result.getNamespace(), namespace -> new ConcurrentHashSet());
        this.namespaceSingletonMaps.get(result.getNamespace()).add(result);
        return result;
    }

    public Optional<Service> getSingletonIfExist(String namespace, String group, String name) {
        return this.getSingletonIfExist(Service.newService(namespace, group, name));
    }

    public Optional<Service> getSingletonIfExist(Service service) {
        return Optional.ofNullable(this.singletonRepository.get(service));
    }

    public Set<String> getAllNamespaces() {
        return this.namespaceSingletonMaps.keySet();
    }

    public Service removeSingleton(Service service) {
        if (this.namespaceSingletonMaps.containsKey(service.getNamespace())) {
            this.namespaceSingletonMaps.get(service.getNamespace()).remove(service);
        }
        return this.singletonRepository.remove(service);
    }

    public boolean containSingleton(Service service) {
        return this.singletonRepository.containsKey(service);
    }

    public int size() {
        return this.singletonRepository.size();
    }
}

