/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.raft;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.naming.consistency.persistent.ClusterVersionJudgement;
import com.alibaba.nacos.naming.consistency.persistent.raft.BaseRaftEvent;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeer;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class RaftListener
implements SmartApplicationListener {
    private final ServerMemberManager memberManager;
    private final ClusterVersionJudgement versionJudgement;
    private volatile boolean stopUpdate = false;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();

    public RaftListener(ServerMemberManager memberManager, ClusterVersionJudgement versionJudgement) {
        this.memberManager = memberManager;
        this.versionJudgement = versionJudgement;
        this.init();
    }

    private void init() {
        this.versionJudgement.registerObserver(isAllNewVersion -> {
            ReentrantReadWriteLock.WriteLock lock = this.writeLock;
            lock.lock();
            try {
                this.stopUpdate = isAllNewVersion;
                if (this.stopUpdate) {
                    this.removeOldRaftMetadata();
                }
            }
            finally {
                lock.unlock();
            }
        }, -2);
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return BaseRaftEvent.class.isAssignableFrom(eventType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationEvent event) {
        ReentrantReadWriteLock.ReadLock lock = this.readLock;
        lock.lock();
        try {
            if (event instanceof BaseRaftEvent && !this.stopUpdate) {
                BaseRaftEvent raftEvent = (BaseRaftEvent)event;
                RaftPeer local = raftEvent.getLocal();
                String json = JacksonUtils.toJson((Object)local);
                Map map = (Map)JacksonUtils.toObj((String)json, HashMap.class);
                Member self = this.memberManager.getSelf();
                self.setExtendVal("naming", (Object)map);
                this.memberManager.update(self);
            }
            if (this.stopUpdate) {
                this.removeOldRaftMetadata();
            }
        }
        finally {
            lock.unlock();
        }
    }

    void removeOldRaftMetadata() {
        Loggers.RAFT.warn("start to move old raft protocol metadata");
        Member self = this.memberManager.getSelf();
        self.delExtendVal("naming");
        this.memberManager.update(self);
    }
}

