/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.ephemeral.distro;

import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.core.Instances;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class DataStore {
    private Map<String, Datum> dataMap = new ConcurrentHashMap<String, Datum>(1024);

    public void put(String key, Datum value) {
        this.dataMap.put(key, value);
    }

    public Datum remove(String key) {
        return this.dataMap.remove(key);
    }

    public Set<String> keys() {
        return this.dataMap.keySet();
    }

    public Datum get(String key) {
        return this.dataMap.get(key);
    }

    public boolean contains(String key) {
        return this.dataMap.containsKey(key);
    }

    public Map<String, Datum> batchGet(List<String> keys) {
        HashMap<String, Datum> map = new HashMap<String, Datum>(128);
        for (String key : keys) {
            Datum datum = this.dataMap.get(key);
            if (datum == null) continue;
            map.put(key, datum);
        }
        return map;
    }

    public int getInstanceCount() {
        int count = 0;
        for (Map.Entry<String, Datum> entry : this.dataMap.entrySet()) {
            try {
                Datum instancesDatum = entry.getValue();
                if (!(instancesDatum.value instanceof Instances)) continue;
                count += ((Instances)instancesDatum.value).getInstanceList().size();
            }
            catch (Exception exception) {}
        }
        return count;
    }

    public Map<String, Datum> getDataMap() {
        return this.dataMap;
    }
}

