/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.filter.impl;

import com.alibaba.nacos.api.config.filter.IConfigFilter;
import com.alibaba.nacos.api.config.filter.IConfigFilterChain;
import com.alibaba.nacos.api.config.filter.IConfigRequest;
import com.alibaba.nacos.api.config.filter.IConfigResponse;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;

public class ConfigFilterChainManager
implements IConfigFilterChain {
    private final List<IConfigFilter> filters = new ArrayList<IConfigFilter>();

    public ConfigFilterChainManager(Properties properties) {
        ServiceLoader<IConfigFilter> configFilters = ServiceLoader.load(IConfigFilter.class);
        for (IConfigFilter configFilter : configFilters) {
            configFilter.init(properties);
            this.addFilter(configFilter);
        }
    }

    public synchronized ConfigFilterChainManager addFilter(IConfigFilter filter) {
        IConfigFilter currentValue;
        int i;
        for (i = 0; i < this.filters.size() && !(currentValue = this.filters.get(i)).getFilterName().equals(filter.getFilterName()); ++i) {
            if (filter.getOrder() >= currentValue.getOrder() && i < this.filters.size()) {
                continue;
            }
            this.filters.add(i, filter);
            break;
        }
        if (i == this.filters.size()) {
            this.filters.add(i, filter);
        }
        return this;
    }

    public void doFilter(IConfigRequest request, IConfigResponse response) throws NacosException {
        new VirtualFilterChain(this.filters).doFilter(request, response);
    }

    private static class VirtualFilterChain
    implements IConfigFilterChain {
        private final List<? extends IConfigFilter> additionalFilters;
        private int currentPosition = 0;

        public VirtualFilterChain(List<? extends IConfigFilter> additionalFilters) {
            this.additionalFilters = additionalFilters;
        }

        public void doFilter(IConfigRequest request, IConfigResponse response) throws NacosException {
            if (this.currentPosition != this.additionalFilters.size()) {
                ++this.currentPosition;
                IConfigFilter nextFilter = this.additionalFilters.get(this.currentPosition - 1);
                nextFilter.doFilter(request, response, (IConfigFilterChain)this);
            }
        }
    }
}

