/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiOverflowStrategy;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class MultiOverflow<T> {
    private final Multi<T> upstream;

    public MultiOverflow(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public Multi<T> buffer() {
        return new MultiOverflowStrategy<T>(this.upstream, null, null).buffer();
    }

    @CheckReturnValue
    public Multi<T> buffer(int size) {
        return new MultiOverflowStrategy<T>(this.upstream, null, null).buffer(size);
    }

    @CheckReturnValue
    public Multi<T> drop() {
        return new MultiOverflowStrategy<T>(this.upstream, null, null).drop();
    }

    @CheckReturnValue
    public Multi<T> dropPreviousItems() {
        return new MultiOverflowStrategy<T>(this.upstream, null, null).dropPreviousItems();
    }

    @CheckReturnValue
    public MultiOverflowStrategy<T> invoke(Consumer<T> consumer) {
        Consumer<T> actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return new MultiOverflowStrategy<T>(this.upstream, actual, null);
    }

    @CheckReturnValue
    public MultiOverflowStrategy<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((T ignored) -> actual.run());
    }

    @CheckReturnValue
    public MultiOverflowStrategy<T> call(Supplier<Uni<?>> supplier) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.call((T ignored) -> (Uni)actual.get());
    }

    @CheckReturnValue
    public MultiOverflowStrategy<T> call(Function<T, Uni<?>> mapper) {
        Function<T, Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return new MultiOverflowStrategy<T>(this.upstream, null, actual);
    }
}

