/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.antlr.mysql.listener;

import io.seata.sqlparser.antlr.mysql.MySqlContext;
import io.seata.sqlparser.antlr.mysql.parser.MySqlParser;
import io.seata.sqlparser.antlr.mysql.parser.MySqlParserBaseListener;
import io.seata.sqlparser.antlr.mysql.visit.StatementSqlVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class SelectSpecificationSqlListener
extends MySqlParserBaseListener {
    private MySqlContext sqlQueryContext;

    public SelectSpecificationSqlListener(MySqlContext sqlQueryContext) {
        this.sqlQueryContext = sqlQueryContext;
    }

    @Override
    public void enterTableName(MySqlParser.TableNameContext ctx) {
        this.sqlQueryContext.setTableName(ctx.getText());
        super.enterTableName(ctx);
    }

    @Override
    public void enterAtomTableItem(MySqlParser.AtomTableItemContext ctx) {
        String text;
        MySqlParser.UidContext uid = ctx.uid();
        if (uid != null && !(text = uid.getText()).isEmpty()) {
            this.sqlQueryContext.setTableAlias(text);
        }
        super.enterAtomTableItem(ctx);
    }

    @Override
    public void enterFromClause(MySqlParser.FromClauseContext ctx) {
        MySqlParser.ExpressionContext whereExpr = ctx.whereExpr;
        StatementSqlVisitor statementSqlVisitor = new StatementSqlVisitor();
        String text = ((StringBuilder)statementSqlVisitor.visit((ParseTree)whereExpr)).toString();
        this.sqlQueryContext.setWhereCondition(text);
        super.enterFromClause(ctx);
    }

    @Override
    public void enterFullColumnNameExpressionAtom(MySqlParser.FullColumnNameExpressionAtomContext ctx) {
        this.sqlQueryContext.addQueryWhereColumnNames(ctx.getText());
        super.enterFullColumnNameExpressionAtom(ctx);
    }

    @Override
    public void enterConstantExpressionAtom(MySqlParser.ConstantExpressionAtomContext ctx) {
        this.sqlQueryContext.addQueryWhereValColumnNames(ctx.getText());
        super.enterConstantExpressionAtom(ctx);
    }

    @Override
    public void enterSelectElements(MySqlParser.SelectElementsContext ctx) {
        List<MySqlParser.SelectElementContext> selectElementContexts = ctx.selectElement();
        for (MySqlParser.SelectElementContext selectElementContext : selectElementContexts) {
            this.sqlQueryContext.addQueryColumnNames(selectElementContext.getText());
        }
        super.enterSelectElements(ctx);
    }
}

