/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.proctrl.handler;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.FrameworkException;
import io.seata.saga.proctrl.Instruction;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.proctrl.ProcessRouter;
import io.seata.saga.proctrl.ProcessType;
import io.seata.saga.proctrl.eventing.EventPublisher;
import io.seata.saga.proctrl.handler.RouterHandler;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRouterHandler
implements RouterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRouterHandler.class);
    private EventPublisher<ProcessContext> eventPublisher;
    private Map<String, ProcessRouter> processRouters;

    @Override
    public void route(ProcessContext context) throws FrameworkException {
        try {
            ProcessType processType = DefaultRouterHandler.matchProcessType(context);
            if (processType == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Process type not found, context=" + context);
                }
                throw new FrameworkException(FrameworkErrorCode.ProcessTypeNotFound);
            }
            ProcessRouter processRouter = this.processRouters.get(processType.getCode());
            if (processRouter == null) {
                LOGGER.error("Cannot find process router by type " + processType.getCode() + ", context=" + context);
                throw new FrameworkException(FrameworkErrorCode.ProcessRouterNotFound);
            }
            Instruction instruction = processRouter.route(context);
            if (instruction == null) {
                LOGGER.warn("route instruction is null, process end:" + context);
            } else {
                context.setInstruction(instruction);
                this.eventPublisher.publish(context);
            }
        }
        catch (FrameworkException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new FrameworkException(ex, ex.getMessage(), FrameworkErrorCode.UnknownAppError);
        }
    }

    public static ProcessType matchProcessType(ProcessContext context) {
        ProcessType processType = (ProcessType)((Object)context.getVariable("_ProcessType_"));
        if (processType == null) {
            processType = ProcessType.STATE_LANG;
        }
        return processType;
    }

    public void setEventPublisher(EventPublisher<ProcessContext> eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setProcessRouters(Map<String, ProcessRouter> processRouters) {
        this.processRouters = processRouters;
    }
}

