/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.handlers;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.StateMachineEngine;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.invoker.ServiceInvoker;
import io.seata.saga.engine.pcext.InterceptibleStateHandler;
import io.seata.saga.engine.pcext.StateHandler;
import io.seata.saga.engine.pcext.StateHandlerInterceptor;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.proctrl.HierarchicalProcessContext;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.CompensateSubStateMachineState;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.ServiceTaskState;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.TaskState;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import io.seata.saga.statelang.domain.impl.ServiceTaskStateImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class ServiceTaskStateHandler
implements StateHandler,
InterceptibleStateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTaskStateHandler.class);
    private List<StateHandlerInterceptor> interceptors;

    @Override
    public void process(ProcessContext context) throws EngineExecutionException {
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        ServiceTaskStateImpl state = (ServiceTaskStateImpl)instruction.getState(context);
        String serviceName = state.getServiceName();
        String methodName = state.getServiceMethod();
        StateInstance stateInstance = (StateInstance)context.getVariable("_current_state_instance_");
        try {
            Object result;
            List input = (List)context.getVariable("inputParams");
            stateInstance.setStatus(ExecutionStatus.RU);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(">>>>>>>>>>>>>>>>>>>>>> Start to execute State[" + state.getName() + "], ServiceName[" + serviceName + "], Method[" + methodName + "], Input:" + input);
            }
            if (state instanceof CompensateSubStateMachineState) {
                result = this.compensateSubStateMachine(context, state, input, stateInstance, (StateMachineEngine)context.getVariable("_current_statemachine_engine_"));
            } else {
                StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
                ServiceInvoker serviceInvoker = stateMachineConfig.getServiceInvokerManager().getServiceInvoker(state.getServiceType());
                if (serviceInvoker == null) {
                    throw new EngineExecutionException("No such ServiceInvoker[" + state.getServiceType() + "]", FrameworkErrorCode.ObjectNotExists);
                }
                if (serviceInvoker instanceof ApplicationContextAware) {
                    ((ApplicationContextAware)serviceInvoker).setApplicationContext(stateMachineConfig.getApplicationContext());
                }
                result = serviceInvoker.invoke(state, input.toArray());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("<<<<<<<<<<<<<<<<<<<<<< State[" + state.getName() + "], ServiceName[" + serviceName + "], Method[" + methodName + "] Execute finish. result: " + result);
            }
            if (result != null) {
                ((HierarchicalProcessContext)context).setVariableLocally("outputParams", result);
            }
        }
        catch (Exception e) {
            LOGGER.error("<<<<<<<<<<<<<<<<<<<<<< State[" + state.getName() + "], ServiceName[" + serviceName + "], Method[" + methodName + "] Execute failed.", (Throwable)e);
            ((HierarchicalProcessContext)context).setVariableLocally("currentException", e);
            ServiceTaskStateHandler.handleException(context, state, e);
        }
    }

    private Object compensateSubStateMachine(ProcessContext context, ServiceTaskState state, Object input, StateInstance stateInstance, StateMachineEngine engine) {
        String subStateMachineParentId = (String)context.getVariable(state.getName() + "_sub_machine_parent_id_");
        if (StringUtils.isEmpty((Object)subStateMachineParentId)) {
            throw new EngineExecutionException("sub statemachine parentId is required", FrameworkErrorCode.ObjectNotExists);
        }
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        List<StateMachineInstance> subInst = stateMachineConfig.getStateLogStore().queryStateMachineInstanceByParentId(subStateMachineParentId);
        if (subInst == null || subInst.size() <= 0) {
            throw new EngineExecutionException("cannot find sub statemachine instance by parentId:" + subStateMachineParentId, FrameworkErrorCode.ObjectNotExists);
        }
        String subStateMachineInstId = subInst.get(0).getId();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(">>>>>>>>>>>>>>>>>>>>>> Start to compensate sub statemachine [id:" + subStateMachineInstId + "]");
        }
        Map startParams = new HashMap(0);
        if (input instanceof List) {
            List listInputParams = (List)input;
            if (listInputParams.size() > 0) {
                startParams = (Map)listInputParams.get(0);
            }
        } else if (input instanceof Map) {
            startParams = (Map)input;
        }
        StateMachineInstance compensateInst = engine.compensate(subStateMachineInstId, startParams);
        stateInstance.setStatus(compensateInst.getCompensationStatus());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(">>>>>>>>>>>>>>>>>>>>>> Compensate sub statemachine [id:" + subStateMachineInstId + "] finished with status[" + (Object)((Object)compensateInst.getStatus()) + "], compensateState[" + (Object)((Object)compensateInst.getCompensationStatus()) + "]");
        }
        return compensateInst.getEndParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleException(ProcessContext context, AbstractTaskState state, Exception e) {
        List<TaskState.ExceptionMatch> catches = state.getCatches();
        if (catches != null && catches.size() > 0) {
            for (TaskState.ExceptionMatch exceptionMatch : catches) {
                List<String> exceptions = exceptionMatch.getExceptions();
                List<Class<? extends Exception>> exceptionClasses = exceptionMatch.getExceptionClasses();
                if (exceptions == null || exceptions.size() <= 0) continue;
                if (exceptionClasses == null) {
                    TaskState.ExceptionMatch exceptionMatch2 = exceptionMatch;
                    synchronized (exceptionMatch2) {
                        exceptionClasses = exceptionMatch.getExceptionClasses();
                        if (exceptionClasses == null) {
                            exceptionClasses = new ArrayList<Class<? extends Exception>>(exceptions.size());
                            for (String expStr : exceptions) {
                                Class<?> expClass = null;
                                try {
                                    expClass = ServiceTaskStateHandler.class.getClassLoader().loadClass(expStr);
                                }
                                catch (Exception e1) {
                                    LOGGER.warn("Cannot Load Exception Class by getClass().getClassLoader()", (Throwable)e1);
                                    try {
                                        expClass = Thread.currentThread().getContextClassLoader().loadClass(expStr);
                                    }
                                    catch (Exception e2) {
                                        LOGGER.warn("Cannot Load Exception Class by Thread.currentThread().getContextClassLoader()", (Throwable)e2);
                                    }
                                }
                                if (expClass == null) continue;
                                exceptionClasses.add(expClass);
                            }
                        }
                    }
                }
                for (Class clazz : exceptionClasses) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    ((HierarchicalProcessContext)context).setVariableLocally("_current_exception_route_", exceptionMatch.getNext());
                    return;
                }
            }
        }
        LOGGER.error("Task execution failed and no catches configured");
        ((HierarchicalProcessContext)context).setVariableLocally("_is_exception_not_catch_", true);
    }

    @Override
    public List<StateHandlerInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<StateHandlerInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

