/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.invoker.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import io.seata.common.exception.FrameworkErrorCode;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.invoker.ServiceInvoker;
import io.seata.saga.statelang.domain.ServiceTaskState;
import io.seata.saga.statelang.domain.impl.ServiceTaskStateImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanServiceInvoker
implements ServiceInvoker,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBeanServiceInvoker.class);
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(ServiceTaskState serviceTaskState, Object ... input) {
        ServiceTaskStateImpl state = (ServiceTaskStateImpl)serviceTaskState;
        Object bean = this.applicationContext.getBean(state.getServiceName());
        Method method = state.getMethod();
        if (method == null) {
            ServiceTaskStateImpl serviceTaskStateImpl = state;
            synchronized (serviceTaskStateImpl) {
                method = state.getMethod();
                if (method == null && (method = this.findMethod(bean.getClass(), state.getServiceMethod(), state.getParameterTypes())) != null) {
                    state.setMethod(method);
                }
            }
        }
        if (method == null) {
            throw new EngineExecutionException("No such method[" + state.getServiceMethod() + "] on BeanClass[" + bean.getClass() + "]", FrameworkErrorCode.NoSuchMethod);
        }
        Object[] args = new Object[method.getParameterCount()];
        try {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (input != null && input.length > 0) {
                int len = input.length < paramTypes.length ? input.length : paramTypes.length;
                for (int i = 0; i < len; ++i) {
                    args[i] = this.toJavaObject(input[i], paramTypes[i]);
                }
            }
        }
        catch (Exception e) {
            throw new EngineExecutionException(e, "Input to java object error, Method[" + state.getServiceMethod() + "] on BeanClass[" + bean.getClass() + "]", FrameworkErrorCode.InvalidParameter);
        }
        return this.invokeMethod(bean, method, args);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected Method findMethod(Class<?> clazz, String methodName, List<String> parameterTypes) {
        if (parameterTypes == null || parameterTypes.size() == 0) {
            return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz, (String)methodName);
        }
        Class[] paramClassTypes = new Class[parameterTypes.size()];
        for (int i = 0; i < parameterTypes.size(); ++i) {
            paramClassTypes[i] = this.classForName(parameterTypes.get(i));
        }
        return BeanUtils.findDeclaredMethod(clazz, (String)methodName, (Class[])paramClassTypes);
    }

    protected Class classForName(String className) {
        Class<?> clazz = this.getPrimitiveClass(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (clazz == null) {
            throw new EngineExecutionException("Parameter class not found [" + className + "]", FrameworkErrorCode.ObjectNotExists);
        }
        return clazz;
    }

    protected Object invokeMethod(Object serviceBean, Method method, Object ... input) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new EngineExecutionException("Method[" + method.getName() + "] must be public", FrameworkErrorCode.MethodNotPublic);
        }
        try {
            return method.invoke(serviceBean, input);
        }
        catch (InvocationTargetException e) {
            Throwable targetExp = e.getTargetException();
            if (targetExp == null) {
                throw new EngineExecutionException(e, e.getMessage(), FrameworkErrorCode.MethodInvokeError);
            }
            if (targetExp instanceof RuntimeException) {
                throw (RuntimeException)targetExp;
            }
            throw new EngineExecutionException(targetExp, targetExp.getMessage(), FrameworkErrorCode.MethodInvokeError);
        }
        catch (Exception e) {
            throw new EngineExecutionException(e, e.getMessage(), FrameworkErrorCode.MethodInvokeError);
        }
    }

    protected Object toJavaObject(Object value, Class paramType) {
        if (value == null) {
            return value;
        }
        if (paramType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (this.isPrimitive(paramType)) {
            return value;
        }
        String jsonValue = JSON.toJSONString((Object)value);
        return JSON.parseObject((String)jsonValue, (Class)paramType, (Feature[])new Feature[]{Feature.SupportAutoType});
    }

    protected boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Time.class || clazz == Timestamp.class || clazz.isEnum();
    }

    protected Class getPrimitiveClass(String className) {
        if (Boolean.TYPE.getName().equals(className)) {
            return Boolean.TYPE;
        }
        if (Character.TYPE.getName().equals(className)) {
            return Character.TYPE;
        }
        if (Byte.TYPE.getName().equals(className)) {
            return Byte.TYPE;
        }
        if (Short.TYPE.getName().equals(className)) {
            return Short.TYPE;
        }
        if (Integer.TYPE.getName().equals(className)) {
            return Integer.TYPE;
        }
        if (Long.TYPE.getName().equals(className)) {
            return Long.TYPE;
        }
        if (Float.TYPE.getName().equals(className)) {
            return Float.TYPE;
        }
        if (Double.TYPE.getName().equals(className)) {
            return Double.TYPE;
        }
        return null;
    }
}

