/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.parser;

import io.seata.common.loader.LoadLevel;
import io.seata.rm.datasource.undo.BranchUndoLog;
import io.seata.rm.datasource.undo.UndoLogParser;
import io.seata.rm.datasource.undo.parser.KryoSerializer;
import io.seata.rm.datasource.undo.parser.KryoSerializerFactory;

@LoadLevel(name="kryo")
public class KryoUndoLogParser
implements UndoLogParser {
    public static final String NAME = "kryo";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] getDefaultContent() {
        KryoSerializer kryoSerializer = KryoSerializerFactory.getInstance().get();
        try {
            byte[] byArray = kryoSerializer.serialize(new BranchUndoLog());
            return byArray;
        }
        finally {
            KryoSerializerFactory.getInstance().returnKryo(kryoSerializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(BranchUndoLog branchUndoLog) {
        KryoSerializer kryoSerializer = KryoSerializerFactory.getInstance().get();
        try {
            byte[] byArray = kryoSerializer.serialize(branchUndoLog);
            return byArray;
        }
        finally {
            KryoSerializerFactory.getInstance().returnKryo(kryoSerializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BranchUndoLog decode(byte[] bytes) {
        KryoSerializer kryoSerializer = KryoSerializerFactory.getInstance().get();
        try {
            BranchUndoLog branchUndoLog = (BranchUndoLog)kryoSerializer.deserialize(bytes);
            return branchUndoLog;
        }
        finally {
            KryoSerializerFactory.getInstance().returnKryo(kryoSerializer);
        }
    }
}

